/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import java.security.cert.X509Certificate;

@Lint(name="e_cert_unique_identifier_version_not_2_or_3", description="Unique identifiers MUST only appear if the X.509 version is 2 or 3", citation="RFC 5280: 4.1.2.8", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class CertUniqueIdentifierVersionNot2Or3
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        boolean hasUniqueIdField;
        boolean bl = hasUniqueIdField = certificate.getIssuerUniqueID() != null || certificate.getSubjectUniqueID() != null;
        if (hasUniqueIdField && certificate.getVersion() != 2 && certificate.getVersion() != 3) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }
}

