/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;

@Lint(name="e_cert_extensions_version_not_3", description="The extensions field MUST only appear in version 3 certificates", citation="RFC 5280: 4.1.2.9", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class CertExtensionsVersionNot3
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (certificate.getVersion() != 3 && Utils.hasExtensions(certificate)) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }
}

