/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;

@Lint(name="e_ca_subject_field_empty", description="The subject field of a CA certificate MUST have a non-empty distinguished name", citation="RFC 5280: 4.1.2.6", source=Source.RFC2459, effectiveDate=EffectiveDate.RFC2459)
public class CASubjectFieldEmpty
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] encodedSubjectDN = certificate.getSubjectX500Principal().getEncoded();
        X500Name x500Name = X500Name.getInstance((Object)encodedSubjectDN);
        if (x500Name.getRDNs().length > 0) {
            return LintResult.of(Status.PASS);
        }
        return LintResult.of(Status.ERROR);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isCA(certificate);
    }
}

