/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.community;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.DateUtils;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;

@Lint(name="e_validity_time_not_positive", description="Certificates MUST have a positive time for which they are valid", citation="lint.AWSLabs certlint", source=Source.COMMUNITY, effectiveDate=EffectiveDate.ZERO)
public class ValidityTimeNotPositive
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        ZonedDateTime notAfter;
        ZonedDateTime notBefore = DateUtils.getNotBefore(certificate);
        if (notBefore.isAfter(notAfter = DateUtils.getNotAfter(certificate))) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }
}

