/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.community;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

@Lint(name="e_rsa_exp_negative", description="RSA public key exponent MUST be positive", citation="awslabs certlint", source=Source.COMMUNITY, effectiveDate=EffectiveDate.ZERO)
public class RsaExpNegative
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)certificate.getPublicKey();
        if (rsaPublicKey.getPublicExponent().compareTo(BigInteger.ZERO) == -1) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isPublicKeyRSA(certificate);
    }
}

