/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.community;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;

@Lint(name="e_ian_dns_name_includes_null_char", description="DNSName MUST NOT include a null character", citation="awslabs certlint", source=Source.COMMUNITY, effectiveDate=EffectiveDate.ZERO)
public class IanDnsNameIncludesNullChar
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawIAN = certificate.getExtensionValue(Extension.issuerAlternativeName.getId());
        try {
            List<GeneralName> dnsNames = Utils.getDNSNames(rawIAN);
            for (GeneralName generalName : dnsNames) {
                char[] chars;
                for (char character : chars = generalName.getName().toString().toCharArray()) {
                    if (character != '\u0000') continue;
                    return LintResult.of(Status.ERROR);
                }
            }
        }
        catch (IOException ex) {
            return LintResult.of(Status.FATAL);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.issuerAlternativeName.getId());
    }
}

