/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_smime_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.SMIMEUtils;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;

@Lint(name="e_smime_legacy_aia_shall_have_one_http", description="SMIME Legacy certificates authorityInformationAccess When provided, at least one accessMethod SHALL have the URI scheme HTTP. Other schemes (LDAP, FTP, ...) MAY be present.", citation="BRs: 7.1.2.3c", source=Source.CABF_SMIME_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.SMIME_BR_1_0_DATE)
public class SmimeLegacyAiaShallHaveOneHttp
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] aiaValue = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)ASN1OctetString.getInstance((Object)aiaValue).getOctets());
        AccessDescription[] accessDescriptions = aia.getAccessDescriptions();
        boolean atLeastOneHttpInOCSP = false;
        boolean atLeastOneHttpInCaIssuers = false;
        for (AccessDescription accessDescription : accessDescriptions) {
            GeneralName accessLocation = accessDescription.getAccessLocation();
            if (AccessDescription.id_ad_ocsp.equals((ASN1Primitive)accessDescription.getAccessMethod())) {
                if (!this.startsWithCorrectPrefix(accessLocation)) continue;
                atLeastOneHttpInOCSP = true;
                continue;
            }
            if (!AccessDescription.id_ad_caIssuers.equals((ASN1Primitive)accessDescription.getAccessMethod()) || !this.startsWithCorrectPrefix(accessLocation)) continue;
            atLeastOneHttpInCaIssuers = true;
        }
        if (!atLeastOneHttpInOCSP) {
            return LintResult.of(Status.ERROR, "at least one id-ad-ocsp accessMethod MUST have the URI scheme HTTP");
        }
        if (!atLeastOneHttpInCaIssuers) {
            return LintResult.of(Status.ERROR, "at least one id-ad-caIssuers accessMethod MUST have the URI scheme HTTP");
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasAuthorityInformationAccessExtension(certificate) && Utils.isSubscriberCert(certificate) && SMIMEUtils.isLegacySMIMECertificate(certificate);
    }

    private boolean startsWithCorrectPrefix(GeneralName generalName) {
        ASN1IA5String asn1IA5String;
        boolean startsWithCorrectPrefix = false;
        if (generalName.getTagNo() == 6 && ((asn1IA5String = (ASN1IA5String)generalName.getName()).getString().startsWith("http://") || asn1IA5String.getString().startsWith("https://"))) {
            startsWithCorrectPrefix = true;
        }
        return startsWithCorrectPrefix;
    }
}

