/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_smime_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.SMIMEUtils;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="w_key_usage_criticality", description="keyUsage... This extension SHOULD be marked critical", citation="7.1.2.3.e", source=Source.CABF_SMIME_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.SMIME_BR_1_0_DATE)
public class KeyUsageCriticality
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (!Utils.isExtensionCritical(certificate, Extension.keyUsage.getId())) {
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isSubscriberCert(certificate) && SMIMEUtils.isSMIMEBRCertificate(certificate) && Utils.hasKeyUsageExtension(certificate);
    }
}

