/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;

@Lint(name="e_subject_contains_noninformational_value", description="Subject name fields must not contain '.','-',' ' or any other indication that the field has been omitted", citation="BRs: 7.1.4.2.2", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABEffectiveDate)
public class SubjectContainsNoninformationalValue
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<AttributeTypeAndValue> attributeTypeAndValues = Utils.getSubjectDNNameComponents(certificate);
        for (AttributeTypeAndValue attributeTypeAndValue : attributeTypeAndValues) {
            char[] characters = attributeTypeAndValue.getValue().toString().toCharArray();
            if (this.checkAlphaNumericOrUTF8Present(characters)) continue;
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }

    public boolean checkAlphaNumericOrUTF8Present(char[] characters) {
        for (char character : characters) {
            if (!(character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9') && character <= '\u007f') continue;
            return true;
        }
        return false;
    }
}

