/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="w_sub_ca_eku_critical", description="Subordinate CA certificate extkeyUsage extension should be marked non-critical if present", citation="BRs: 7.1.2.2", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABV116Date)
public class SubCaEkuCritical
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (Utils.isExtensionCritical(certificate, Extension.extendedKeyUsage.getId())) {
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isSubCA(certificate) && Utils.hasExtendedKeyUsageExtension(certificate);
    }
}

