/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

@Lint(name="e_rsa_public_exponent_too_small", description="RSA: Value of public exponent is an odd number equal to 3 or more.", citation="BRs: 6.1.6", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABV113Date)
public class RsaPublicExponentTooSmall
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)certificate.getPublicKey();
        BigInteger exponent = rsaPublicKey.getPublicExponent();
        if (exponent.compareTo(BigInteger.valueOf(3L)) == -1) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isPublicKeyRSA(certificate);
    }
}

