/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

@Lint(name="w_rsa_mod_factors_smaller_than_752", description="RSA: Modulus SHOULD also have the following characteristics: no factors smaller than 752", citation="BRs: 6.1.6", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABV113Date)
public class RsaModFactorsSmallerThan752
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        BigInteger product = new BigInteger("1451887755777639901511587432083070202422614380984889313550570919659315177065956574359078912654149167643992684236991305777574330831666511589145701059710742276692757882915756220901998212975756543223550490431013061082131040808010565293748926901442915057819663730454818359472391642885328171302299245556663073719855");
        RSAPublicKey rsaPublicKey = (RSAPublicKey)certificate.getPublicKey();
        if (rsaPublicKey.getModulus().gcd(product).compareTo(BigInteger.ONE) != 0) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isPublicKeyRSA(certificate);
    }
}

