/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.lints.cabf_br.ExtSanDirectoryNamePresent;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_ext_san_rfc822_name_present", description="The Subject Alternate Name extension MUST contain only 'dnsName' and 'ipaddress' name types.", citation="BRs: 7.1.4.2.1", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABEffectiveDate)
public class ExtSanRfc822NamePresent
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        return ExtSanDirectoryNamePresent.sanContainsGeneralNameWithTag(certificate, 1);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.subjectAlternativeName.getId());
    }
}

