/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint;

import de.mtg.jzlint.Lint;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LintClassesContainer {
    public static final String PACKAGE_NAME = "de/mtg/jzlint/lints";
    private static LintClassesContainer lintClassesContainer;
    private final List<Class<?>> lintClasses;

    private LintClassesContainer(List<Class<?>> lintClasses) {
        this.lintClasses = lintClasses;
    }

    public static synchronized LintClassesContainer getInstance() {
        if (lintClassesContainer == null) {
            try {
                lintClassesContainer = new LintClassesContainer(LintClassesContainer.getClasses(PACKAGE_NAME));
            }
            catch (IOException | ClassNotFoundException | URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        return lintClassesContainer;
    }

    public List<Class<?>> getLintClasses() {
        return this.lintClasses;
    }

    private static List<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException, URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL urlResource = classLoader.getResource(packageName);
        URLConnection urlConnection = urlResource.openConnection();
        ArrayList classes = new ArrayList();
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
            Enumeration<JarEntry> entries = jarURLConnection.getJarFile().entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().replace("/", ".");
                classes.add(Class.forName(className.substring(0, className.length() - 6)));
            }
        } else {
            Enumeration<URL> resources = classLoader.getResources(packageName);
            ArrayList lintClassesCandidates = new ArrayList();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Stream<Path> walk = Files.walk(Paths.get(resource.toURI()), new FileVisitOption[0]);
                try {
                    walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(lintClassesCandidates::add);
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
            for (Path path : lintClassesCandidates) {
                String className = path.getName(path.getNameCount() - 1).toString();
                className = className.substring(0, className.length() - 6);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(path.getName(path.getNameCount() - 6));
                stringBuilder.append(".");
                stringBuilder.append(path.getName(path.getNameCount() - 5));
                stringBuilder.append(".");
                stringBuilder.append(path.getName(path.getNameCount() - 4));
                stringBuilder.append(".");
                stringBuilder.append(path.getName(path.getNameCount() - 3));
                stringBuilder.append(".");
                stringBuilder.append(path.getName(path.getNameCount() - 2));
                stringBuilder.append(".");
                stringBuilder.append(className);
                classes.add(Class.forName(stringBuilder.toString()));
            }
        }
        Predicate<Class> lintAnnotationPresent = c -> c.isAnnotationPresent(Lint.class);
        return classes.stream().filter(lintAnnotationPresent).collect(Collectors.toList());
    }
}

