/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.types.types._visitor;

import de.monticore.types.types._ast.ASTComplexArrayType;
import de.monticore.types.types._ast.ASTComplexReferenceType;
import de.monticore.types.types._ast.ASTImportStatement;
import de.monticore.types.types._ast.ASTPrimitiveArrayType;
import de.monticore.types.types._ast.ASTPrimitiveType;
import de.monticore.types.types._ast.ASTQualifiedName;
import de.monticore.types.types._ast.ASTSimpleReferenceType;
import de.monticore.types.types._ast.ASTTypeArguments;
import de.monticore.types.types._ast.ASTTypeParameters;
import de.monticore.types.types._ast.ASTTypeVariableDeclaration;
import de.monticore.types.types._ast.ASTTypesNode;
import de.monticore.types.types._ast.ASTVoidType;
import de.monticore.types.types._ast.ASTWildcardType;
import de.monticore.types.types._visitor.TypesVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;

public abstract class TypesParentAwareVisitor
implements TypesVisitor {
    final Stack<ASTTypesNode> parents = new Stack();

    public Optional<ASTTypesNode> getParent() {
        if (!this.parents.isEmpty()) {
            ASTTypesNode topElement = this.parents.peek();
            return Optional.of(topElement);
        }
        return Optional.empty();
    }

    public List<ASTTypesNode> getParents() {
        return new ArrayList<ASTTypesNode>(this.parents);
    }

    @Override
    public void traverse(ASTQualifiedName node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTComplexArrayType node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTPrimitiveArrayType node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTVoidType node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTPrimitiveType node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTSimpleReferenceType node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTComplexReferenceType node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTTypeArguments node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTWildcardType node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTTypeParameters node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTTypeVariableDeclaration node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTImportStatement node) {
        this.parents.push(node);
        TypesVisitor.super.traverse(node);
        this.parents.pop();
    }
}

