/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.types.types._od;

import de.monticore.ast.ASTNode;
import de.monticore.generating.templateengine.reporting.commons.ReportingRepository;
import de.monticore.prettyprint.IndentPrinter;
import de.monticore.symboltable.Scope;
import de.monticore.symboltable.Symbol;
import de.monticore.types.types._ast.ASTArrayType;
import de.monticore.types.types._ast.ASTComplexArrayType;
import de.monticore.types.types._ast.ASTComplexReferenceType;
import de.monticore.types.types._ast.ASTImportStatement;
import de.monticore.types.types._ast.ASTPrimitiveArrayType;
import de.monticore.types.types._ast.ASTPrimitiveType;
import de.monticore.types.types._ast.ASTQualifiedName;
import de.monticore.types.types._ast.ASTSimpleReferenceType;
import de.monticore.types.types._ast.ASTTypeArgument;
import de.monticore.types.types._ast.ASTTypeArguments;
import de.monticore.types.types._ast.ASTTypeParameters;
import de.monticore.types.types._ast.ASTTypeVariableDeclaration;
import de.monticore.types.types._ast.ASTTypesNode;
import de.monticore.types.types._ast.ASTVoidType;
import de.monticore.types.types._ast.ASTWildcardType;
import de.monticore.types.types._visitor.TypesVisitor;
import de.se_rwth.commons.Names;
import de.se_rwth.commons.StringTransformations;
import java.util.Iterator;

public class Types2OD
implements TypesVisitor {
    private TypesVisitor realThis = this;
    protected IndentPrinter pp;
    protected ReportingRepository reporting;
    protected boolean printEmptyOptional = false;
    protected boolean printEmptyList = false;

    public Types2OD(IndentPrinter printer, ReportingRepository reporting) {
        this.reporting = reporting;
        this.pp = printer;
    }

    @Override
    public void handle(ASTQualifiedName node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTQualifiedName");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        String sep = "";
        String str = "\"";
        Iterator<String> it = node.getParts().iterator();
        boolean isEmpty = true;
        if (it.hasNext() || this.printEmptyList) {
            this.pp.print((Object)"parts = [");
            isEmpty = false;
        }
        while (it.hasNext()) {
            this.pp.print((Object)sep);
            this.pp.print((Object)(str + String.valueOf(it.next()) + str));
            sep = ", ";
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTComplexArrayType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTComplexArrayType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        if (null != node.getComponentType()) {
            this.pp.print((Object)"componentType");
            this.pp.print((Object)" = ");
            node.getComponentType().accept(this.getRealThis());
            this.pp.println((Object)";");
        }
        this.printAttribute("dimensions", String.valueOf(node.getDimensions()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTPrimitiveArrayType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTPrimitiveArrayType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        if (null != node.getComponentType()) {
            this.pp.print((Object)"componentType");
            this.pp.print((Object)" = ");
            node.getComponentType().accept(this.getRealThis());
            this.pp.println((Object)";");
        }
        this.printAttribute("dimensions", String.valueOf(node.getDimensions()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTVoidType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTVoidType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTPrimitiveType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTPrimitiveType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("primitive", String.valueOf(node.getPrimitive()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTSimpleReferenceType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTSimpleReferenceType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        String sep = "";
        String str = "\"";
        Iterator<String> it = node.getNames().iterator();
        boolean isEmpty = true;
        if (it.hasNext() || this.printEmptyList) {
            this.pp.print((Object)"names = [");
            isEmpty = false;
        }
        while (it.hasNext()) {
            this.pp.print((Object)sep);
            this.pp.print((Object)(str + String.valueOf(it.next()) + str));
            sep = ", ";
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
        }
        if (node.getTypeArguments().isPresent()) {
            this.pp.print((Object)"typeArguments");
            this.pp.print((Object)" = ");
            node.getTypeArguments().get().accept(this.getRealThis());
            this.pp.println((Object)";");
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"typeArguments = Optional.Empty;");
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTComplexReferenceType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTComplexReferenceType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        Iterator<ASTSimpleReferenceType> iter_simpleReferenceTypes = node.getSimpleReferenceTypes().iterator();
        boolean isEmpty = true;
        if (iter_simpleReferenceTypes.hasNext()) {
            this.pp.print((Object)"simpleReferenceTypes");
            this.pp.print((Object)" = [");
            this.pp.println((Object)("// *size: " + node.getSimpleReferenceTypes().size()));
            this.pp.indent();
            isEmpty = false;
        } else if (this.printEmptyList) {
            this.pp.print((Object)"simpleReferenceTypes");
            this.pp.println((Object)" = [];");
        }
        boolean isFirst = true;
        while (iter_simpleReferenceTypes.hasNext()) {
            if (!isFirst) {
                this.pp.println((Object)",");
            }
            isFirst = false;
            iter_simpleReferenceTypes.next().accept(this.getRealThis());
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
            this.pp.unindent();
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTTypeArguments node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTTypeArguments");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        Iterator<ASTTypeArgument> iter_typeArguments = node.getTypeArguments().iterator();
        boolean isEmpty = true;
        if (iter_typeArguments.hasNext()) {
            this.pp.print((Object)"typeArguments");
            this.pp.print((Object)" = [");
            this.pp.println((Object)("// *size: " + node.getTypeArguments().size()));
            this.pp.indent();
            isEmpty = false;
        } else if (this.printEmptyList) {
            this.pp.print((Object)"typeArguments");
            this.pp.println((Object)" = [];");
        }
        boolean isFirst = true;
        while (iter_typeArguments.hasNext()) {
            if (!isFirst) {
                this.pp.println((Object)",");
            }
            isFirst = false;
            iter_typeArguments.next().accept(this.getRealThis());
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
            this.pp.unindent();
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTWildcardType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTWildcardType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        if (node.getUpperBound().isPresent()) {
            this.pp.print((Object)"upperBound");
            this.pp.print((Object)" = ");
            node.getUpperBound().get().accept(this.getRealThis());
            this.pp.println((Object)";");
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"upperBound = Optional.Empty;");
        }
        if (node.getLowerBound().isPresent()) {
            this.pp.print((Object)"lowerBound");
            this.pp.print((Object)" = ");
            node.getLowerBound().get().accept(this.getRealThis());
            this.pp.println((Object)";");
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"lowerBound = Optional.Empty;");
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTTypeParameters node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTTypeParameters");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        Iterator<ASTTypeVariableDeclaration> iter_typeVariableDeclarations = node.getTypeVariableDeclarations().iterator();
        boolean isEmpty = true;
        if (iter_typeVariableDeclarations.hasNext()) {
            this.pp.print((Object)"typeVariableDeclarations");
            this.pp.print((Object)" = [");
            this.pp.println((Object)("// *size: " + node.getTypeVariableDeclarations().size()));
            this.pp.indent();
            isEmpty = false;
        } else if (this.printEmptyList) {
            this.pp.print((Object)"typeVariableDeclarations");
            this.pp.println((Object)" = [];");
        }
        boolean isFirst = true;
        while (iter_typeVariableDeclarations.hasNext()) {
            if (!isFirst) {
                this.pp.println((Object)",");
            }
            isFirst = false;
            iter_typeVariableDeclarations.next().accept(this.getRealThis());
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
            this.pp.unindent();
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTTypeVariableDeclaration node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTTypeVariableDeclaration");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("name", "\"" + String.valueOf(node.getName()) + "\"");
        Iterator<ASTComplexReferenceType> iter_upperBounds = node.getUpperBounds().iterator();
        boolean isEmpty = true;
        if (iter_upperBounds.hasNext()) {
            this.pp.print((Object)"upperBounds");
            this.pp.print((Object)" = [");
            this.pp.println((Object)("// *size: " + node.getUpperBounds().size()));
            this.pp.indent();
            isEmpty = false;
        } else if (this.printEmptyList) {
            this.pp.print((Object)"upperBounds");
            this.pp.println((Object)" = [];");
        }
        boolean isFirst = true;
        while (iter_upperBounds.hasNext()) {
            if (!isFirst) {
                this.pp.println((Object)",");
            }
            isFirst = false;
            iter_upperBounds.next().accept(this.getRealThis());
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
            this.pp.unindent();
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTImportStatement node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTImportStatement");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        String sep = "";
        String str = "\"";
        Iterator<String> it = node.getImportList().iterator();
        boolean isEmpty = true;
        if (it.hasNext() || this.printEmptyList) {
            this.pp.print((Object)"importList = [");
            isEmpty = false;
        }
        while (it.hasNext()) {
            this.pp.print((Object)sep);
            this.pp.print((Object)(str + String.valueOf(it.next()) + str));
            sep = ", ";
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
        }
        this.printAttribute("star", String.valueOf(node.isStar()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTArrayType node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.types.types._ast.ASTArrayType");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        if (null != node.getComponentType()) {
            this.pp.print((Object)"componentType");
            this.pp.print((Object)" = ");
            node.getComponentType().accept(this.getRealThis());
            this.pp.println((Object)";");
        }
        this.printAttribute("dimensions", String.valueOf(node.getDimensions()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    private void printAttribute(String name, String value) {
        this.pp.print((Object)name);
        this.pp.print((Object)" = ");
        this.pp.print((Object)value);
        this.pp.println((Object)";");
    }

    private void printObject(String objName, String objType) {
        this.pp.print((Object)objName);
        this.pp.print((Object)":");
        this.pp.print((Object)Names.getSimpleName((String)objType));
        this.pp.println((Object)" {");
    }

    public String printObjectDiagram(String modelName, ASTTypesNode node) {
        this.pp.clearBuffer();
        this.pp.setIndentLength(2);
        this.pp.print((Object)"objectdiagram ");
        this.pp.print((Object)modelName);
        this.pp.println((Object)" {");
        this.pp.indent();
        node.accept(this.getRealThis());
        this.pp.unindent();
        this.pp.println((Object)"}");
        return this.pp.getContent();
    }

    @Override
    public void setRealThis(TypesVisitor realThis) {
        this.realThis = realThis;
    }

    @Override
    public TypesVisitor getRealThis() {
        return this.realThis;
    }

    public boolean isPrintEmptyOptional() {
        return this.printEmptyOptional;
    }

    public void setPrintEmptyOptional(boolean printEmptyOptional) {
        this.printEmptyOptional = printEmptyOptional;
    }

    public boolean isPrintEmptyList() {
        return this.printEmptyList;
    }

    public void setPrintEmptyList(boolean printEmptyList) {
        this.printEmptyList = printEmptyList;
    }
}

