/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.types.prettyprint;

import de.monticore.literals.prettyprint.LiteralsPrettyPrinterConcreteVisitor;
import de.monticore.prettyprint.IndentPrinter;
import de.monticore.types.types._ast.ASTComplexArrayType;
import de.monticore.types.types._ast.ASTComplexReferenceType;
import de.monticore.types.types._ast.ASTPrimitiveArrayType;
import de.monticore.types.types._ast.ASTPrimitiveType;
import de.monticore.types.types._ast.ASTQualifiedName;
import de.monticore.types.types._ast.ASTSimpleReferenceType;
import de.monticore.types.types._ast.ASTTypeArguments;
import de.monticore.types.types._ast.ASTTypeParameters;
import de.monticore.types.types._ast.ASTTypeVariableDeclaration;
import de.monticore.types.types._ast.ASTTypesNode;
import de.monticore.types.types._ast.ASTVoidType;
import de.monticore.types.types._ast.ASTWildcardType;
import de.monticore.types.types._visitor.TypesVisitor;
import de.se_rwth.commons.Names;
import java.util.Iterator;

public class TypesPrettyPrinterConcreteVisitor
extends LiteralsPrettyPrinterConcreteVisitor
implements TypesVisitor {
    private TypesVisitor realThis = this;

    public TypesPrettyPrinterConcreteVisitor(IndentPrinter printer) {
        super(printer);
    }

    @Override
    public void visit(ASTQualifiedName a) {
        this.getPrinter().print((Object)Names.getQualifiedName(a.getParts()));
    }

    @Override
    public void handle(ASTComplexArrayType a) {
        a.getComponentType().accept(this.getRealThis());
        for (int i = 0; i < a.getDimensions(); ++i) {
            this.getPrinter().print((Object)"[]");
        }
    }

    @Override
    public void handle(ASTPrimitiveArrayType a) {
        a.getComponentType().accept(this.getRealThis());
        for (int i = 0; i < a.getDimensions(); ++i) {
            this.getPrinter().print((Object)"[]");
        }
    }

    @Override
    public void visit(ASTVoidType a) {
        this.getPrinter().print((Object)"void");
    }

    @Override
    public void visit(ASTPrimitiveType a) {
        switch (a.getPrimitive()) {
            case 1: {
                this.getPrinter().print((Object)"boolean");
                break;
            }
            case 2: {
                this.getPrinter().print((Object)"byte");
                break;
            }
            case 3: {
                this.getPrinter().print((Object)"char");
                break;
            }
            case 8: {
                this.getPrinter().print((Object)"short");
                break;
            }
            case 6: {
                this.getPrinter().print((Object)"int");
                break;
            }
            case 5: {
                this.getPrinter().print((Object)"float");
                break;
            }
            case 7: {
                this.getPrinter().print((Object)"long");
                break;
            }
            case 4: {
                this.getPrinter().print((Object)"double");
                break;
            }
            default: {
                this.getPrinter().print((Object)"");
            }
        }
    }

    @Override
    public void visit(ASTSimpleReferenceType a) {
        this.getPrinter().print((Object)Names.getQualifiedName(a.getNames()));
    }

    @Override
    public void handle(ASTComplexReferenceType a) {
        this.printList(a.getSimpleReferenceTypes().iterator(), ".");
    }

    @Override
    public void handle(ASTTypeArguments a) {
        this.getPrinter().print((Object)"<");
        this.printList(a.getTypeArguments().iterator(), ", ");
        this.getPrinter().print((Object)">");
    }

    @Override
    public void handle(ASTWildcardType a) {
        this.getPrinter().print((Object)"?");
        if (a.getUpperBound().isPresent()) {
            this.getPrinter().print((Object)" extends ");
            a.getUpperBound().get().accept(this.getRealThis());
        } else if (a.getLowerBound().isPresent()) {
            this.getPrinter().print((Object)" super ");
            a.getLowerBound().get().accept(this.getRealThis());
        }
    }

    @Override
    public void handle(ASTTypeParameters a) {
        if (!a.getTypeVariableDeclarations().isEmpty()) {
            this.getPrinter().print((Object)"<");
            this.printList(a.getTypeVariableDeclarations().iterator(), ", ");
            this.getPrinter().print((Object)">");
        }
    }

    @Override
    public void handle(ASTTypeVariableDeclaration a) {
        this.getPrinter().print((Object)a.getName());
        if (a.getUpperBounds() != null && !a.getUpperBounds().isEmpty()) {
            this.getPrinter().print((Object)" extends ");
            this.printList(a.getUpperBounds().iterator(), "& ");
        }
    }

    protected void printList(Iterator<? extends ASTTypesNode> iter, String seperator) {
        String sep = "";
        while (iter.hasNext()) {
            this.getPrinter().print((Object)sep);
            iter.next().accept(this.getRealThis());
            sep = seperator;
        }
    }

    public String prettyprint(ASTTypesNode a) {
        this.getPrinter().clearBuffer();
        a.accept(this.getRealThis());
        return this.getPrinter().getContent();
    }

    @Override
    public void setRealThis(TypesVisitor realThis) {
        this.realThis = realThis;
    }

    @Override
    public TypesVisitor getRealThis() {
        return this.realThis;
    }
}

