/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.types;

import de.monticore.types.types._ast.ASTArrayType;
import de.monticore.types.types._ast.ASTComplexReferenceType;
import de.monticore.types.types._ast.ASTPrimitiveType;
import de.monticore.types.types._ast.ASTReferenceType;
import de.monticore.types.types._ast.ASTReturnType;
import de.monticore.types.types._ast.ASTSimpleReferenceType;
import de.monticore.types.types._ast.ASTType;
import de.monticore.types.types._ast.ASTTypeArgument;
import de.monticore.types.types._ast.ASTTypeArguments;
import de.monticore.types.types._ast.ASTTypeParameters;
import de.monticore.types.types._ast.ASTTypeVariableDeclaration;
import de.monticore.types.types._ast.ASTVoidType;
import de.monticore.types.types._ast.ASTWildcardType;
import de.se_rwth.commons.Names;
import java.util.List;

public class TypesPrinter {
    private static TypesPrinter instance;

    private TypesPrinter() {
    }

    private static TypesPrinter getInstance() {
        if (instance == null) {
            instance = new TypesPrinter();
        }
        return instance;
    }

    public static String printType(ASTType type) {
        return TypesPrinter.getInstance().doPrintType(type);
    }

    protected String doPrintType(ASTType type) {
        if (type instanceof ASTArrayType) {
            return this.doPrintArrayType((ASTArrayType)type);
        }
        if (type instanceof ASTPrimitiveType) {
            return this.doPrintPrimitiveType((ASTPrimitiveType)type);
        }
        if (type instanceof ASTReferenceType) {
            return this.doPrintReferenceType((ASTReferenceType)type);
        }
        return "";
    }

    public static String printReferenceType(ASTReferenceType type) {
        return TypesPrinter.getInstance().doPrintReferenceType(type);
    }

    protected String doPrintReferenceType(ASTReferenceType type) {
        if (type instanceof ASTSimpleReferenceType) {
            return this.doPrintSimpleReferenceType((ASTSimpleReferenceType)type);
        }
        if (type instanceof ASTComplexReferenceType) {
            return this.doPrintComplexReferenceType((ASTComplexReferenceType)type);
        }
        return "";
    }

    public static String printReturnType(ASTReturnType type) {
        return TypesPrinter.getInstance().doPrintReturnType(type);
    }

    protected String doPrintReturnType(ASTReturnType type) {
        if (type instanceof ASTType) {
            return this.doPrintType((ASTType)type);
        }
        if (type instanceof ASTVoidType) {
            return this.doPrintVoidType((ASTVoidType)type);
        }
        return "";
    }

    public static String printTypeArgument(ASTTypeArgument type) {
        return TypesPrinter.getInstance().doPrintTypeArgument(type);
    }

    protected String doPrintTypeArgument(ASTTypeArgument type) {
        if (type instanceof ASTWildcardType) {
            return this.doPrintWildcardType((ASTWildcardType)type);
        }
        if (type instanceof ASTType) {
            return this.doPrintType((ASTType)type);
        }
        return "";
    }

    public static String printTypeWithoutTypeArguments(ASTType type) {
        return TypesPrinter.getInstance().doPrintTypeWithoutTypeArguments(type);
    }

    protected String doPrintTypeWithoutTypeArguments(ASTType type) {
        if (type instanceof ASTArrayType) {
            return this.doPrintArrayType((ASTArrayType)type);
        }
        if (type instanceof ASTPrimitiveType) {
            return this.doPrintPrimitiveType((ASTPrimitiveType)type);
        }
        if (type instanceof ASTReferenceType) {
            return this.doPrintReferenceTypeWithoutTypeArguments((ASTReferenceType)type);
        }
        return "";
    }

    public static String printTypeWithoutTypeArgumentsAndDimension(ASTType type) {
        return TypesPrinter.getInstance().doPrintTypeWithoutTypeArgumentsAndDimension(type);
    }

    protected String doPrintTypeWithoutTypeArgumentsAndDimension(ASTType type) {
        if (type instanceof ASTArrayType) {
            return this.doPrintTypeWithoutTypeArgumentsAndDimension(((ASTArrayType)type).getComponentType());
        }
        if (type instanceof ASTPrimitiveType) {
            return this.doPrintPrimitiveType((ASTPrimitiveType)type);
        }
        if (type instanceof ASTReferenceType) {
            return this.doPrintTypeWithoutTypeArguments((ASTReferenceType)type);
        }
        return "";
    }

    public static String printTypeParameters(ASTTypeParameters params) {
        return TypesPrinter.getInstance().doPrintTypeParameters(params);
    }

    protected String doPrintTypeParameters(ASTTypeParameters params) {
        if (params != null && params.getTypeVariableDeclarations() != null && !params.getTypeVariableDeclarations().isEmpty()) {
            return "<" + this.doPrintTypeVariableDeclarationList(params.getTypeVariableDeclarations()) + ">";
        }
        return "";
    }

    public static String printTypeVariableDeclarationList(List<ASTTypeVariableDeclaration> decl) {
        return TypesPrinter.getInstance().doPrintTypeVariableDeclarationList(decl);
    }

    protected String doPrintTypeVariableDeclarationList(List<ASTTypeVariableDeclaration> decl) {
        StringBuilder ret = new StringBuilder();
        if (decl != null) {
            String sep = "";
            for (ASTTypeVariableDeclaration d : decl) {
                ret.append(sep + this.doPrintTypeVariableDeclaration(d));
                sep = ", ";
            }
        }
        return ret.toString();
    }

    public static String printTypeVariableDeclaration(ASTTypeVariableDeclaration decl) {
        return TypesPrinter.getInstance().doPrintTypeVariableDeclaration(decl);
    }

    protected String doPrintTypeVariableDeclaration(ASTTypeVariableDeclaration decl) {
        StringBuilder ret = new StringBuilder();
        if (decl != null) {
            ret.append(decl.getName());
            if (decl.getUpperBounds() != null && !decl.getUpperBounds().isEmpty()) {
                String sep = " extends ";
                for (ASTType aSTType : decl.getUpperBounds()) {
                    ret.append(sep + this.doPrintType(aSTType));
                    sep = " & ";
                }
            }
        }
        return ret.toString();
    }

    public static String printVoidType(ASTVoidType type) {
        return TypesPrinter.getInstance().doPrintVoidType(type);
    }

    protected String doPrintVoidType(ASTVoidType type) {
        if (type != null) {
            return "void";
        }
        return "";
    }

    public static String printPrimitiveType(ASTPrimitiveType type) {
        return TypesPrinter.getInstance().doPrintPrimitiveType(type);
    }

    protected String doPrintPrimitiveType(ASTPrimitiveType type) {
        if (type == null) {
            return "";
        }
        if (type.getPrimitive() == 1) {
            return "boolean";
        }
        if (type.getPrimitive() == 2) {
            return "byte";
        }
        if (type.getPrimitive() == 3) {
            return "char";
        }
        if (type.getPrimitive() == 8) {
            return "short";
        }
        if (type.getPrimitive() == 6) {
            return "int";
        }
        if (type.getPrimitive() == 5) {
            return "float";
        }
        if (type.getPrimitive() == 7) {
            return "long";
        }
        if (type.getPrimitive() == 4) {
            return "double";
        }
        return "";
    }

    public static String printArrayType(ASTArrayType type) {
        return TypesPrinter.getInstance().doPrintArrayType(type);
    }

    protected String doPrintArrayType(ASTArrayType type) {
        if (type != null) {
            StringBuilder dimension = new StringBuilder();
            dimension.append(this.doPrintType(type.getComponentType()));
            for (int i = 0; i < type.getDimensions(); ++i) {
                dimension.append("[]");
            }
            return dimension.toString();
        }
        return "";
    }

    public static String printReferenceTypeList(List<ASTReferenceType> type) {
        return TypesPrinter.getInstance().doPrintReferenceTypeList(type);
    }

    protected String doPrintReferenceTypeList(List<ASTReferenceType> type) {
        StringBuilder ret = new StringBuilder();
        if (type != null) {
            String sep = "";
            for (ASTReferenceType refType : type) {
                ret.append(sep + this.doPrintReferenceType(refType));
                sep = ", ";
            }
        }
        return ret.toString();
    }

    public static String printSimpleReferenceType(ASTSimpleReferenceType type) {
        return TypesPrinter.getInstance().doPrintSimpleReferenceType(type);
    }

    protected String doPrintSimpleReferenceType(ASTSimpleReferenceType type) {
        if (type != null) {
            if (type.getTypeArguments().isPresent()) {
                return Names.getQualifiedName(type.getNames()) + this.doPrintTypeArguments(type.getTypeArguments().get());
            }
            return Names.getQualifiedName(type.getNames());
        }
        return "";
    }

    public static String printComplexReferenceType(ASTComplexReferenceType type) {
        return TypesPrinter.getInstance().doPrintComplexReferenceType(type);
    }

    protected String doPrintComplexReferenceType(ASTComplexReferenceType type) {
        String ret = "";
        if (type != null && type.getSimpleReferenceTypes() != null) {
            return this.doPrintSimpleReferenceTypeList(type.getSimpleReferenceTypes());
        }
        return ret;
    }

    public static String printSimpleReferenceTypeList(List<ASTSimpleReferenceType> type) {
        return TypesPrinter.getInstance().doPrintSimpleReferenceTypeList(type);
    }

    protected String doPrintSimpleReferenceTypeList(List<ASTSimpleReferenceType> argList) {
        StringBuilder ret = new StringBuilder();
        if (argList != null) {
            String sep = "";
            for (ASTSimpleReferenceType arg : argList) {
                ret.append(sep + this.doPrintSimpleReferenceType(arg));
                sep = ". ";
            }
        }
        return ret.toString();
    }

    public static String printTypeArguments(ASTTypeArguments args) {
        return TypesPrinter.getInstance().doPrintTypeArguments(args);
    }

    protected String doPrintTypeArguments(ASTTypeArguments args) {
        if (args != null && args.getTypeArguments() != null && !args.getTypeArguments().isEmpty()) {
            return "<" + this.doPrintTypeArgumentList(args.getTypeArguments()) + ">";
        }
        return "";
    }

    public static String printTypeArgumentList(List<ASTTypeArgument> argList) {
        return TypesPrinter.getInstance().doPrintTypeArgumentList(argList);
    }

    protected String doPrintTypeArgumentList(List<ASTTypeArgument> argList) {
        StringBuilder ret = new StringBuilder();
        if (argList != null) {
            String sep = "";
            for (ASTTypeArgument arg : argList) {
                ret.append(sep + this.doPrintTypeArgument(arg));
                sep = ", ";
            }
        }
        return ret.toString();
    }

    public static String printWildcardType(ASTWildcardType type) {
        return TypesPrinter.getInstance().doPrintWildcardType(type);
    }

    protected String doPrintWildcardType(ASTWildcardType type) {
        StringBuilder ret = new StringBuilder();
        if (type != null) {
            ret.append("?");
            if (type.getUpperBound().isPresent()) {
                ret.append(" extends " + this.doPrintType(type.getUpperBound().get()));
            } else if (type.getLowerBound().isPresent()) {
                ret.append(" super " + this.doPrintType(type.getLowerBound().get()));
            }
        }
        return ret.toString();
    }

    protected String doPrintReferenceTypeWithoutTypeArguments(ASTReferenceType type) {
        if (type instanceof ASTSimpleReferenceType) {
            return this.doPrintSimpleReferenceTypeWithoutTypeArguments((ASTSimpleReferenceType)type);
        }
        if (type instanceof ASTComplexReferenceType) {
            return this.doPrintComplexReferenceTypeWithoutTypeArguments((ASTComplexReferenceType)type);
        }
        return "";
    }

    protected String doPrintSimpleReferenceTypeWithoutTypeArguments(ASTSimpleReferenceType type) {
        if (type != null) {
            return Names.getQualifiedName(type.getNames());
        }
        return "";
    }

    protected String doPrintComplexReferenceTypeWithoutTypeArguments(ASTComplexReferenceType type) {
        if (type != null && type.getSimpleReferenceTypes() != null) {
            return this.doPrintSimpleReferenceTypeListWithoutTypeArguments(type.getSimpleReferenceTypes());
        }
        return "";
    }

    protected String doPrintSimpleReferenceTypeListWithoutTypeArguments(List<ASTSimpleReferenceType> argList) {
        StringBuilder ret = new StringBuilder();
        if (argList != null) {
            String sep = "";
            for (ASTSimpleReferenceType arg : argList) {
                ret.append(sep + this.doPrintSimpleReferenceTypeWithoutTypeArguments(arg));
                sep = ". ";
            }
        }
        return ret.toString();
    }
}

