/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.types;

import de.monticore.ast.ASTNode;
import de.monticore.generating.templateengine.reporting.commons.Layouter;
import de.monticore.literals.LiteralsNodeIdentHelper;
import de.monticore.types.types._ast.ASTPrimitiveType;
import de.monticore.types.types._ast.ASTQualifiedName;
import de.monticore.types.types._ast.ASTSimpleReferenceType;
import de.monticore.types.types._ast.ASTTypeParameters;
import de.monticore.types.types._ast.ASTTypeVariableDeclaration;
import java.util.List;

public class TypesNodeIdentHelper
extends LiteralsNodeIdentHelper {
    protected String unqualName(ASTQualifiedName ast) {
        List<String> parts = ast.getParts();
        return parts.get(parts.size() - 1);
    }

    public String getIdent(ASTPrimitiveType a) {
        int p = a.getPrimitive();
        return this.format(String.valueOf(p), Layouter.nodeName((ASTNode)a));
    }

    public String getIdent(ASTQualifiedName a) {
        return this.format(this.unqualName(a), Layouter.nodeName((ASTNode)a));
    }

    public String getIdent(ASTSimpleReferenceType a) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < a.getNames().size(); ++i) {
            name.append(a.getNames().get(i));
            if (i == a.getNames().size() - 1) continue;
            name.append(".");
        }
        return this.format(name.toString(), Layouter.nodeName((ASTNode)a));
    }

    public String getIdent(ASTTypeParameters a) {
        List<ASTTypeVariableDeclaration> l = a.getTypeVariableDeclarations();
        String n = "";
        if (l.isEmpty()) {
            n = n + "-";
        }
        if (!l.isEmpty()) {
            n = n + l.get(0).getName();
        }
        if (l.size() > 1) {
            n = n + "..";
        }
        return this.format(n, Layouter.nodeName((ASTNode)a));
    }
}

