/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.types;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import de.monticore.types.TypesPrinter;
import de.monticore.types.types._ast.ASTArrayType;
import de.monticore.types.types._ast.ASTPrimitiveType;
import de.monticore.types.types._ast.ASTSimpleReferenceType;
import de.monticore.types.types._ast.ASTType;
import de.monticore.types.types._ast.ASTTypeArgument;
import de.monticore.types.types._ast.ASTWildcardType;
import de.se_rwth.commons.Names;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class TypesHelper {
    public static final String OPTIONAL = "Optional";

    public static boolean isOptional(ASTType type) {
        return TypesHelper.isGenericTypeWithOneTypeArgument(type, OPTIONAL);
    }

    public static boolean isPrimitive(ASTType type) {
        return type instanceof ASTPrimitiveType;
    }

    public static ASTTypeArgument getReferenceTypeFromOptional(ASTType type) {
        Preconditions.checkArgument((boolean)TypesHelper.isOptional(type));
        return ((ASTSimpleReferenceType)type).getTypeArguments().get().getTypeArguments().get(0);
    }

    public static ASTSimpleReferenceType getSimpleReferenceTypeFromOptional(ASTType type) {
        Preconditions.checkArgument((boolean)TypesHelper.isOptional(type));
        ASTTypeArgument refType = TypesHelper.getReferenceTypeFromOptional(type);
        if (refType instanceof ASTWildcardType && ((ASTWildcardType)refType).getUpperBound().isPresent()) {
            refType = ((ASTWildcardType)refType).getUpperBound().get();
        }
        Preconditions.checkState((boolean)(refType instanceof ASTSimpleReferenceType));
        return (ASTSimpleReferenceType)refType;
    }

    public static String getReferenceNameFromOptional(ASTType type) {
        Preconditions.checkArgument((boolean)TypesHelper.isOptional(type));
        ASTTypeArgument reference = ((ASTSimpleReferenceType)type).getTypeArguments().get().getTypeArguments().get(0);
        if (reference instanceof ASTWildcardType && ((ASTWildcardType)reference).getUpperBound().isPresent()) {
            reference = ((ASTWildcardType)reference).getUpperBound().get();
        }
        Preconditions.checkArgument((boolean)(reference instanceof ASTSimpleReferenceType));
        List<String> names = ((ASTSimpleReferenceType)reference).getNames();
        return names.isEmpty() ? "" : names.get(names.size() - 1);
    }

    public static String getQualifiedReferenceNameFromOptional(ASTType type) {
        Preconditions.checkArgument((boolean)TypesHelper.isOptional(type));
        ASTTypeArgument reference = ((ASTSimpleReferenceType)type).getTypeArguments().get().getTypeArguments().get(0);
        if (reference instanceof ASTWildcardType && ((ASTWildcardType)reference).getUpperBound().isPresent()) {
            reference = ((ASTWildcardType)reference).getUpperBound().get();
        }
        Preconditions.checkArgument((boolean)(reference instanceof ASTSimpleReferenceType));
        List<String> names = ((ASTSimpleReferenceType)reference).getNames();
        return names.isEmpty() ? "" : Names.getQualifiedName(names);
    }

    public static boolean isGenericTypeWithOneTypeArgument(ASTType type, String simpleRefTypeName) {
        if (!(type instanceof ASTSimpleReferenceType)) {
            return false;
        }
        ASTSimpleReferenceType simpleRefType = (ASTSimpleReferenceType)type;
        return Names.getQualifiedName(simpleRefType.getNames()).equals(simpleRefTypeName) && simpleRefType.getTypeArguments().isPresent() && simpleRefType.getTypeArguments().get().getTypeArguments().size() == 1;
    }

    public static int getArrayDimensionIfArrayOrZero(ASTType astType) {
        return astType instanceof ASTArrayType ? ((ASTArrayType)astType).getDimensions() : 0;
    }

    public static Optional<ASTSimpleReferenceType> getFirstTypeArgumentOfGenericType(ASTType type, String simpleRefTypeName) {
        if (!TypesHelper.isGenericTypeWithOneTypeArgument(type, simpleRefTypeName)) {
            return Optional.empty();
        }
        ASTSimpleReferenceType simpleRefType = (ASTSimpleReferenceType)type;
        ASTTypeArgument typeArgument = simpleRefType.getTypeArguments().get().getTypeArguments().get(0);
        if (!(typeArgument instanceof ASTSimpleReferenceType)) {
            return Optional.empty();
        }
        return Optional.of((ASTSimpleReferenceType)typeArgument);
    }

    public static Optional<ASTSimpleReferenceType> getFirstTypeArgumentOfOptional(ASTType type) {
        return TypesHelper.getFirstTypeArgumentOfGenericType(type, OPTIONAL);
    }

    public static String getSimpleName(ASTSimpleReferenceType simpleType) {
        String name = "";
        List<String> qualifiedName = simpleType.getNames();
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            name = qualifiedName.get(qualifiedName.size() - 1);
        }
        return name;
    }

    public static List<String> createListFromDotSeparatedString(String s) {
        return Arrays.asList(s.split("\\."));
    }

    public static String printType(ASTType type) {
        if (TypesHelper.isOptional(type)) {
            ASTTypeArgument ref = TypesHelper.getReferenceTypeFromOptional(type);
            return TypesHelper.printType(ref);
        }
        return TypesPrinter.printType(type);
    }

    public static boolean isNullable(ASTType type) {
        return !TypesHelper.isPrimitive(type);
    }

    public static String printType(ASTTypeArgument type) {
        if (type instanceof ASTWildcardType) {
            return TypesPrinter.printWildcardType((ASTWildcardType)type);
        }
        return TypesHelper.printType((ASTType)type);
    }

    public static String printSimpleRefType(ASTType type) {
        if (TypesHelper.isOptional(type)) {
            return TypesHelper.printType(TypesHelper.getSimpleReferenceTypeFromOptional(type));
        }
        return TypesPrinter.printType(type);
    }

    public static int getPrimitiveType(String typeName) {
        if (Strings.isNullOrEmpty((String)typeName)) {
            return -1;
        }
        switch (typeName) {
            case "boolean": {
                return 1;
            }
            case "float": {
                return 5;
            }
            case "byte": {
                return 2;
            }
            case "char": {
                return 3;
            }
            case "double": {
                return 4;
            }
            case "int": {
                return 6;
            }
            case "short": {
                return 8;
            }
            case "long": {
                return 7;
            }
        }
        return -1;
    }
}

