/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.types;

import de.monticore.symboltable.Scope;
import de.monticore.symboltable.SymbolKind;
import de.monticore.symboltable.types.CommonJFieldSymbol;
import de.monticore.symboltable.types.CommonJMethodSymbol;
import de.monticore.symboltable.types.CommonJTypeSymbol;
import de.monticore.symboltable.types.JTypeSymbol;
import de.monticore.symboltable.types.references.ActualTypeArgument;
import de.monticore.symboltable.types.references.CommonJTypeReference;
import de.monticore.symboltable.types.references.JTypeReference;
import de.monticore.types.TypesHelper;
import de.monticore.types.TypesPrinter;
import de.monticore.types.types._ast.ASTComplexArrayType;
import de.monticore.types.types._ast.ASTComplexReferenceType;
import de.monticore.types.types._ast.ASTReturnType;
import de.monticore.types.types._ast.ASTSimpleReferenceType;
import de.monticore.types.types._ast.ASTType;
import de.monticore.types.types._ast.ASTTypeArgument;
import de.monticore.types.types._ast.ASTTypeParameters;
import de.monticore.types.types._ast.ASTTypeVariableDeclaration;
import de.monticore.types.types._ast.ASTWildcardType;
import de.se_rwth.commons.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JTypeSymbolsHelper {
    private JTypeSymbolsHelper() {
    }

    public static void addTypeArgumentsToTypeSymbol(JTypeReference<?> typeReference, ASTReturnType astType, Scope definingScopeOfReference, JTypeReferenceFactory<?> typeRefFactory) {
        if (astType instanceof ASTSimpleReferenceType) {
            ASTSimpleReferenceType astSimpleReferenceType = (ASTSimpleReferenceType)astType;
            if (!astSimpleReferenceType.getTypeArguments().isPresent()) {
                return;
            }
            ArrayList<ActualTypeArgument> actualTypeArguments = new ArrayList<ActualTypeArgument>();
            for (ASTTypeArgument astTypeArgument : astSimpleReferenceType.getTypeArguments().get().getTypeArguments()) {
                if (astTypeArgument instanceof ASTWildcardType) {
                    ASTWildcardType astWildcardType = (ASTWildcardType)astTypeArgument;
                    if (astWildcardType.lowerBoundIsPresent() || astWildcardType.upperBoundIsPresent()) {
                        boolean lowerBound = astWildcardType.lowerBoundIsPresent();
                        ASTType typeBound = lowerBound ? astWildcardType.getLowerBound().get() : astWildcardType.getUpperBound().get();
                        int dimension = TypesHelper.getArrayDimensionIfArrayOrZero(typeBound);
                        Object typeBoundSymbolReference = typeRefFactory.create(TypesPrinter.printTypeWithoutTypeArgumentsAndDimension(typeBound), definingScopeOfReference, dimension);
                        ActualTypeArgument actualTypeArgument = new ActualTypeArgument(lowerBound, !lowerBound, typeBoundSymbolReference);
                        JTypeSymbolsHelper.addTypeArgumentsToTypeSymbol(typeBoundSymbolReference, typeBound, definingScopeOfReference, typeRefFactory);
                        actualTypeArguments.add(actualTypeArgument);
                    } else {
                        actualTypeArguments.add(new ActualTypeArgument(false, false, typeRefFactory.create("?", definingScopeOfReference, 0)));
                    }
                } else if (astTypeArgument instanceof ASTType) {
                    ASTType astTypeNoBound = (ASTType)astTypeArgument;
                    Object typeArgumentSymbolReference = typeRefFactory.create(TypesPrinter.printTypeWithoutTypeArgumentsAndDimension(astTypeNoBound), definingScopeOfReference, TypesHelper.getArrayDimensionIfArrayOrZero(astTypeNoBound));
                    JTypeSymbolsHelper.addTypeArgumentsToTypeSymbol(typeArgumentSymbolReference, astTypeNoBound, definingScopeOfReference, typeRefFactory);
                    actualTypeArguments.add(new ActualTypeArgument(typeArgumentSymbolReference));
                } else {
                    Log.error((String)("0xE0401 Unknown type argument " + astTypeArgument + " of type " + typeReference));
                }
                typeReference.setActualTypeArguments(actualTypeArguments);
            }
        } else if (astType instanceof ASTComplexReferenceType) {
            ASTComplexReferenceType astComplexReferenceType = (ASTComplexReferenceType)astType;
            for (ASTSimpleReferenceType aSTSimpleReferenceType : astComplexReferenceType.getSimpleReferenceTypes()) {
            }
        } else if (astType instanceof ASTComplexArrayType) {
            ASTComplexArrayType astComplexArrayType = (ASTComplexArrayType)astType;
            JTypeSymbolsHelper.addTypeArgumentsToTypeSymbol(typeReference, astComplexArrayType.getComponentType(), definingScopeOfReference, typeRefFactory);
            int dimension = astComplexArrayType.getDimensions();
            typeReference.setDimension(dimension);
        }
    }

    public static <Y extends JTypeReference<?>, U extends CommonJTypeSymbol<?, ?, ?, Y>> void addInterfacesToType(U jTypeSymbol, List<ASTType> astInterfaceTypeList, Scope definingScopeOfReference, JTypeReferenceFactory<Y> typeRefFactory) {
        for (ASTType astInterfaceType : astInterfaceTypeList) {
            Y jInterfaceTypeSymbolReference = typeRefFactory.create(TypesPrinter.printTypeWithoutTypeArgumentsAndDimension(astInterfaceType), definingScopeOfReference, 0);
            if (astInterfaceType instanceof ASTSimpleReferenceType) {
                JTypeSymbolsHelper.addTypeArgumentsToTypeSymbol(jInterfaceTypeSymbolReference, astInterfaceType, definingScopeOfReference, typeRefFactory);
            } else if (astInterfaceType instanceof ASTComplexReferenceType) {
                ASTComplexReferenceType astComplexReferenceType = (ASTComplexReferenceType)astInterfaceType;
                for (ASTSimpleReferenceType aSTSimpleReferenceType : astComplexReferenceType.getSimpleReferenceTypes()) {
                }
            }
            jTypeSymbol.addInterface(jInterfaceTypeSymbolReference);
        }
    }

    public static <Y extends JTypeReference<?>, U extends CommonJTypeSymbol<?, ?, ?, Y>> List<U> addTypeParametersToMethod(CommonJMethodSymbol<U, ?, ?> jMethodSymbol, Optional<ASTTypeParameters> typeParameters, Scope definingScope, JTypeFactory<U> symbolFactory, JTypeReferenceFactory<Y> typeRefFactory) {
        ArrayList<U> jTypeParameterSymbols = new ArrayList<U>();
        if (typeParameters.isPresent()) {
            ASTTypeParameters astTypeParameters = typeParameters.get();
            for (ASTTypeVariableDeclaration astTypeParameter : astTypeParameters.getTypeVariableDeclarations()) {
                U typeParameter = symbolFactory.createTypeVariable(astTypeParameter.getName());
                jTypeParameterSymbols.add(typeParameter);
                ArrayList<ASTType> types = new ArrayList<ASTType>(astTypeParameter.getUpperBounds());
                JTypeSymbolsHelper.addInterfacesToType(typeParameter, types, definingScope, typeRefFactory);
                jMethodSymbol.addFormalTypeParameter(typeParameter);
            }
        }
        return jTypeParameterSymbols;
    }

    public static <Y extends CommonJTypeReference<?>, U extends CommonJTypeSymbol<?, ?, ?, Y>> List<U> addTypeParametersToType(CommonJTypeSymbol<U, ?, ?, ?> jTypeSymbol, Optional<ASTTypeParameters> optionalTypeParameters, Scope definingScope, JTypeFactory<U> symbolFactory, JTypeReferenceFactory<Y> typeRefFactory) {
        if (optionalTypeParameters.isPresent()) {
            ASTTypeParameters astTypeParameters = optionalTypeParameters.get();
            for (ASTTypeVariableDeclaration astTypeParameter : astTypeParameters.getTypeVariableDeclarations()) {
                String typeVariableName = astTypeParameter.getName();
                U jTypeVariableSymbol = symbolFactory.createTypeVariable(typeVariableName);
                ArrayList<ASTType> types = new ArrayList<ASTType>(astTypeParameter.getUpperBounds());
                JTypeSymbolsHelper.addInterfacesToType(jTypeVariableSymbol, types, definingScope, typeRefFactory);
                jTypeSymbol.addFormalTypeParameter(jTypeVariableSymbol);
            }
        }
        return jTypeSymbol.getFormalTypeParameters();
    }

    public static <Y extends JTypeReference<?>> void initializeJAttributeSymbol(CommonJFieldSymbol<Y> jAttributeSymbol, ASTType astType, int additionalDimensions, Scope definingScope, JTypeReferenceFactory<Y> typeRefFactory) {
        String fieldTypeName = TypesPrinter.printTypeWithoutTypeArgumentsAndDimension(astType);
        Y fieldTypeReference = typeRefFactory.create(fieldTypeName, definingScope, TypesHelper.getArrayDimensionIfArrayOrZero(astType) + additionalDimensions);
        if (astType instanceof ASTSimpleReferenceType) {
            ASTSimpleReferenceType astSimpleReferenceType = (ASTSimpleReferenceType)astType;
            if (astSimpleReferenceType.getTypeArguments().isPresent()) {
                JTypeSymbolsHelper.addTypeArgumentsToTypeSymbol(fieldTypeReference, astSimpleReferenceType, definingScope, typeRefFactory);
            }
        } else if (astType instanceof ASTComplexReferenceType) {
            ASTComplexReferenceType astComplexReferenceType = (ASTComplexReferenceType)astType;
            for (ASTSimpleReferenceType aSTSimpleReferenceType : astComplexReferenceType.getSimpleReferenceTypes()) {
            }
        }
        jAttributeSymbol.setType(fieldTypeReference);
    }

    public static interface JTypeFactory<U extends CommonJTypeSymbol<?, ?, ?, ?>> {
        public U createTypeVariable(String var1);
    }

    public static class CommonJTypeReferenceFactory
    implements JTypeReferenceFactory<CommonJTypeReference<JTypeSymbol>> {
        @Override
        public CommonJTypeReference<JTypeSymbol> create(String referencedSymbolName, Scope definingScopeOfReference, int arrayDimension) {
            CommonJTypeReference tref = new CommonJTypeReference(referencedSymbolName, (SymbolKind)JTypeSymbol.KIND, definingScopeOfReference);
            tref.setDimension(arrayDimension);
            return tref;
        }
    }

    public static interface JTypeReferenceFactory<Y extends JTypeReference<?>> {
        public Y create(String var1, Scope var2, int var3);
    }
}

