/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.literals.prettyprint;

import de.monticore.literals.literals._ast.ASTBooleanLiteral;
import de.monticore.literals.literals._ast.ASTCharLiteral;
import de.monticore.literals.literals._ast.ASTDoubleLiteral;
import de.monticore.literals.literals._ast.ASTFloatLiteral;
import de.monticore.literals.literals._ast.ASTIntLiteral;
import de.monticore.literals.literals._ast.ASTLiteralsNode;
import de.monticore.literals.literals._ast.ASTLongLiteral;
import de.monticore.literals.literals._ast.ASTNullLiteral;
import de.monticore.literals.literals._ast.ASTSignedDoubleLiteral;
import de.monticore.literals.literals._ast.ASTSignedFloatLiteral;
import de.monticore.literals.literals._ast.ASTSignedIntLiteral;
import de.monticore.literals.literals._ast.ASTSignedLongLiteral;
import de.monticore.literals.literals._ast.ASTStringLiteral;
import de.monticore.literals.literals._visitor.LiteralsVisitor;
import de.monticore.prettyprint.IndentPrinter;

public class LiteralsPrettyPrinterConcreteVisitor
implements LiteralsVisitor {
    private LiteralsVisitor realThis = this;
    protected IndentPrinter printer = null;

    public LiteralsPrettyPrinterConcreteVisitor(IndentPrinter printer) {
        this.printer = printer;
    }

    public IndentPrinter getPrinter() {
        return this.printer;
    }

    @Override
    public void visit(ASTNullLiteral a) {
        this.printer.print((Object)"null");
    }

    @Override
    public void visit(ASTBooleanLiteral a) {
        this.printer.print((Object)a.getValue());
    }

    @Override
    public void visit(ASTCharLiteral a) {
        this.printer.print((Object)("'" + a.getSource() + "'"));
    }

    @Override
    public void visit(ASTStringLiteral a) {
        this.printer.print((Object)("\"" + a.getSource() + "\""));
    }

    @Override
    public void visit(ASTIntLiteral a) {
        this.printer.print((Object)a.getSource());
    }

    @Override
    public void visit(ASTLongLiteral a) {
        this.printer.print((Object)a.getSource());
    }

    @Override
    public void visit(ASTFloatLiteral a) {
        this.printer.print((Object)a.getSource());
    }

    @Override
    public void visit(ASTDoubleLiteral a) {
        this.printer.print((Object)a.getSource());
    }

    @Override
    public void visit(ASTSignedDoubleLiteral ast) {
        this.printer.print((Object)ast.getSource());
    }

    @Override
    public void visit(ASTSignedFloatLiteral ast) {
        this.printer.print((Object)ast.getSource());
    }

    @Override
    public void visit(ASTSignedIntLiteral ast) {
        this.printer.print((Object)ast.getSource());
    }

    @Override
    public void visit(ASTSignedLongLiteral ast) {
        this.printer.print((Object)ast.getSource());
    }

    public String prettyprint(ASTLiteralsNode a) {
        a.accept(this.getRealThis());
        return this.printer.getContent();
    }

    @Override
    public void setRealThis(LiteralsVisitor realThis) {
        this.realThis = realThis;
    }

    @Override
    public LiteralsVisitor getRealThis() {
        return this.realThis;
    }
}

