/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.literals.literals._visitor;

import de.monticore.literals.literals._ast.ASTBooleanLiteral;
import de.monticore.literals.literals._ast.ASTCharLiteral;
import de.monticore.literals.literals._ast.ASTDoubleLiteral;
import de.monticore.literals.literals._ast.ASTFloatLiteral;
import de.monticore.literals.literals._ast.ASTIntLiteral;
import de.monticore.literals.literals._ast.ASTLiteralsNode;
import de.monticore.literals.literals._ast.ASTLongLiteral;
import de.monticore.literals.literals._ast.ASTNullLiteral;
import de.monticore.literals.literals._ast.ASTSignedDoubleLiteral;
import de.monticore.literals.literals._ast.ASTSignedFloatLiteral;
import de.monticore.literals.literals._ast.ASTSignedIntLiteral;
import de.monticore.literals.literals._ast.ASTSignedLongLiteral;
import de.monticore.literals.literals._ast.ASTStringLiteral;
import de.monticore.literals.literals._visitor.LiteralsVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;

public abstract class LiteralsParentAwareVisitor
implements LiteralsVisitor {
    final Stack<ASTLiteralsNode> parents = new Stack();

    public Optional<ASTLiteralsNode> getParent() {
        if (!this.parents.isEmpty()) {
            ASTLiteralsNode topElement = this.parents.peek();
            return Optional.of(topElement);
        }
        return Optional.empty();
    }

    public List<ASTLiteralsNode> getParents() {
        return new ArrayList<ASTLiteralsNode>(this.parents);
    }

    @Override
    public void traverse(ASTNullLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTBooleanLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTCharLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTStringLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTIntLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTSignedIntLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTLongLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTSignedLongLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTFloatLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTSignedFloatLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTDoubleLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTSignedDoubleLiteral node) {
        this.parents.push(node);
        LiteralsVisitor.super.traverse(node);
        this.parents.pop();
    }
}

