/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.literals.literals._od;

import de.monticore.ast.ASTNode;
import de.monticore.generating.templateengine.reporting.commons.ReportingRepository;
import de.monticore.literals.literals._ast.ASTBooleanLiteral;
import de.monticore.literals.literals._ast.ASTCharLiteral;
import de.monticore.literals.literals._ast.ASTDoubleLiteral;
import de.monticore.literals.literals._ast.ASTFloatLiteral;
import de.monticore.literals.literals._ast.ASTIntLiteral;
import de.monticore.literals.literals._ast.ASTLiteralsNode;
import de.monticore.literals.literals._ast.ASTLongLiteral;
import de.monticore.literals.literals._ast.ASTNullLiteral;
import de.monticore.literals.literals._ast.ASTSignedDoubleLiteral;
import de.monticore.literals.literals._ast.ASTSignedFloatLiteral;
import de.monticore.literals.literals._ast.ASTSignedIntLiteral;
import de.monticore.literals.literals._ast.ASTSignedLongLiteral;
import de.monticore.literals.literals._ast.ASTStringLiteral;
import de.monticore.literals.literals._visitor.LiteralsVisitor;
import de.monticore.prettyprint.IndentPrinter;
import de.monticore.symboltable.Scope;
import de.monticore.symboltable.Symbol;
import de.se_rwth.commons.Names;
import de.se_rwth.commons.StringTransformations;

public class Literals2OD
implements LiteralsVisitor {
    private LiteralsVisitor realThis = this;
    protected IndentPrinter pp;
    protected ReportingRepository reporting;
    protected boolean printEmptyOptional = false;
    protected boolean printEmptyList = false;

    public Literals2OD(IndentPrinter printer, ReportingRepository reporting) {
        this.reporting = reporting;
        this.pp = printer;
    }

    @Override
    public void handle(ASTNullLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTNullLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTBooleanLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTBooleanLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", String.valueOf(node.getSource()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTCharLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTCharLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTStringLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTStringLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTIntLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTIntLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTSignedIntLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTSignedIntLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.printAttribute("negative", String.valueOf(node.isNegative()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTLongLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTLongLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTSignedLongLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTSignedLongLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.printAttribute("negative", String.valueOf(node.isNegative()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTFloatLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTFloatLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTSignedFloatLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTSignedFloatLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.printAttribute("negative", String.valueOf(node.isNegative()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTDoubleLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTDoubleLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTSignedDoubleLiteral node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.literals.literals._ast.ASTSignedDoubleLiteral");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("source", "\"" + String.valueOf(node.getSource()) + "\"");
        this.printAttribute("negative", String.valueOf(node.isNegative()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    private void printAttribute(String name, String value) {
        this.pp.print((Object)name);
        this.pp.print((Object)" = ");
        this.pp.print((Object)value);
        this.pp.println((Object)";");
    }

    private void printObject(String objName, String objType) {
        this.pp.print((Object)objName);
        this.pp.print((Object)":");
        this.pp.print((Object)Names.getSimpleName((String)objType));
        this.pp.println((Object)" {");
    }

    public String printObjectDiagram(String modelName, ASTLiteralsNode node) {
        this.pp.clearBuffer();
        this.pp.setIndentLength(2);
        this.pp.print((Object)"objectdiagram ");
        this.pp.print((Object)modelName);
        this.pp.println((Object)" {");
        this.pp.indent();
        node.accept(this.getRealThis());
        this.pp.unindent();
        this.pp.println((Object)"}");
        return this.pp.getContent();
    }

    @Override
    public void setRealThis(LiteralsVisitor realThis) {
        this.realThis = realThis;
    }

    @Override
    public LiteralsVisitor getRealThis() {
        return this.realThis;
    }

    public boolean isPrintEmptyOptional() {
        return this.printEmptyOptional;
    }

    public void setPrintEmptyOptional(boolean printEmptyOptional) {
        this.printEmptyOptional = printEmptyOptional;
    }

    public boolean isPrintEmptyList() {
        return this.printEmptyList;
    }

    public void setPrintEmptyList(boolean printEmptyList) {
        this.printEmptyList = printEmptyList;
    }
}

