/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.literals.literals._ast;

import de.monticore.ast.ASTNode;
import de.monticore.ast.Comment;
import de.monticore.emf._ast.ASTECNode;
import de.monticore.lexicals.lexicals._visitor.LexicalsVisitor;
import de.monticore.literals.LiteralsHelper;
import de.monticore.literals.literals._ast.ASTLiteralsNode;
import de.monticore.literals.literals._ast.ASTSignedNumericLiteral;
import de.monticore.literals.literals._ast.LiteralsPackage;
import de.monticore.literals.literals._visitor.LiteralsVisitor;
import de.se_rwth.commons.logging.Log;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class ASTSignedLongLiteral
extends ASTECNode
implements ASTSignedNumericLiteral,
ASTLiteralsNode {
    protected String source;
    protected boolean negative;

    protected ASTSignedLongLiteral() {
    }

    protected ASTSignedLongLiteral(String source, boolean negative) {
        this.setSource(source);
        this.setNegative(negative);
    }

    public long getValue() {
        try {
            if (this.negative) {
                return -LiteralsHelper.getInstance().decodeLong(this.getSource());
            }
            return LiteralsHelper.getInstance().decodeLong(this.getSource());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public void accept(LiteralsVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_487 Parameter 'visitor' must not be null.");
        visitor.handle(this);
    }

    public void accept(LexicalsVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_757 Parameter 'visitor' must not be null.");
        if (visitor instanceof LiteralsVisitor) {
            this.accept((LiteralsVisitor)visitor);
        } else {
            Log.error((String)"0xA7000_571AST node type ASTSignedLongLiteral of the sub language de.monticore.literals.Literals expected a visitor of type de.monticore.literals.literals._visitor.LiteralsVisitor, but got de.monticore.lexicals.lexicals._visitor.LexicalsVisitor. Visitors of a super language may not be used on ASTs containing nodes of the sub language. Use a visitor of the sub language.");
        }
    }

    @Override
    public boolean deepEquals(Object o, boolean forceSameOrder) {
        Log.errorIfNull((Object)o, (String)"0xA7006_158 Parameter 'o' must not be null.");
        if (!(o instanceof ASTSignedLongLiteral)) {
            return false;
        }
        ASTSignedLongLiteral comp = (ASTSignedLongLiteral)o;
        return this.equalAttributes(comp);
    }

    @Override
    public boolean deepEquals(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_906 Parameter 'o' must not be null.");
        return this.deepEquals(o, true);
    }

    @Override
    public boolean deepEqualsWithComments(Object o, boolean forceSameOrder) {
        Log.errorIfNull((Object)o, (String)"0xA7006_423 Parameter 'o' must not be null.");
        if (!(o instanceof ASTSignedLongLiteral)) {
            return false;
        }
        ASTSignedLongLiteral comp = (ASTSignedLongLiteral)o;
        return this.equalsWithComments(comp);
    }

    @Override
    public boolean deepEqualsWithComments(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_469 Parameter 'o' must not be null.");
        return this.deepEqualsWithComments(o, true);
    }

    public boolean equalAttributes(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_191 Parameter 'o' must not be null.");
        if (!(o instanceof ASTSignedLongLiteral)) {
            return false;
        }
        ASTSignedLongLiteral comp = (ASTSignedLongLiteral)o;
        if (this.source == null && comp.source != null || this.source != null && !this.source.equals(comp.source)) {
            return false;
        }
        return this.negative == comp.negative;
    }

    @Override
    public boolean equalsWithComments(Object o) {
        Iterator two;
        Iterator one;
        Log.errorIfNull((Object)o, (String)"0xA7006_987 Parameter 'o' must not be null.");
        if (!(o instanceof ASTSignedLongLiteral)) {
            return false;
        }
        ASTSignedLongLiteral comp = (ASTSignedLongLiteral)o;
        if (!this.equalAttributes(comp)) {
            return false;
        }
        if (this.get_PreComments().size() == comp.get_PreComments().size()) {
            one = this.get_PreComments().iterator();
            two = comp.get_PreComments().iterator();
            while (one.hasNext()) {
                if (((Comment)one.next()).equals(two.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.get_PostComments().size() == comp.get_PostComments().size()) {
            one = this.get_PostComments().iterator();
            two = comp.get_PostComments().iterator();
            while (one.hasNext()) {
                if (((Comment)one.next()).equals(two.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public Collection<ASTNode> get_Children() {
        LinkedList<ASTNode> result = new LinkedList<ASTNode>();
        return result;
    }

    public void remove_Child(ASTNode child) {
        Log.errorIfNull((Object)child, (String)"0xA7006_905 Parameter 'child' must not be null.");
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    @Override
    public ASTSignedLongLiteral deepClone() {
        return this.deepClone(this._construct());
    }

    public ASTSignedLongLiteral deepClone(ASTSignedLongLiteral result) {
        Log.errorIfNull((Object)result, (String)"0xA7006_823 Parameter 'result' must not be null.");
        super.deepClone((ASTNode)result);
        result.source = this.source;
        result.negative = this.negative;
        return result;
    }

    protected ASTSignedLongLiteral _construct() {
        return new ASTSignedLongLiteral();
    }

    public String getSource() {
        return this.source;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        boolean oldNegative = this.negative;
        this.negative = negative;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldNegative, negative));
        }
    }

    public void setSource(String source) {
        Log.errorIfNull((Object)source, (String)"0xA7006_012 Parameter 'source' must not be null.");
        String oldSource = this.source;
        this.source = source;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSource, (Object)source));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getSource();
            }
            case 0: {
                return this.isNegative();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setSource((String)newValue);
                return;
            }
            case 0: {
                this.setNegative((Boolean)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setSource(null);
                return;
            }
            case 0: {
                this.setNegative(false);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.getSource() != null;
            }
            case 0: {
                return this.isNegative();
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int featureID, Class<?> baseClass) {
        Log.errorIfNull(baseClass, (String)"0xA7006_111 Parameter 'baseClass' must not be null.");
        return super.eBaseStructuralFeatureID(featureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int featureID, Class<?> baseClass) {
        Log.errorIfNull(baseClass, (String)"0xA7006_822 Parameter 'baseClass' must not be null.");
        return super.eDerivedStructuralFeatureID(featureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(this.getClass().getSimpleName());
        result.append(" Negative: ");
        result.append(this.negative);
        result.append(" Source: ");
        result.append(this.source);
        return result.toString();
    }

    protected EClass eStaticClass() {
        return LiteralsPackage.Literals.ASTSignedLongLiteral;
    }

    public static class Builder {
        protected String source;
        protected boolean negative;

        public ASTSignedLongLiteral build() {
            return new ASTSignedLongLiteral(this.source, this.negative);
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder negative(boolean negative) {
            this.negative = negative;
            return this;
        }
    }
}

