/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.literals.literals._ast;

import de.monticore.ast.ASTNode;
import de.monticore.ast.Comment;
import de.monticore.emf._ast.ASTECNode;
import de.monticore.lexicals.lexicals._visitor.LexicalsVisitor;
import de.monticore.literals.LiteralsHelper;
import de.monticore.literals.literals._ast.ASTLiteralsNode;
import de.monticore.literals.literals._ast.ASTNumericLiteral;
import de.monticore.literals.literals._ast.LiteralsPackage;
import de.monticore.literals.literals._visitor.LiteralsVisitor;
import de.se_rwth.commons.logging.Log;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class ASTDoubleLiteral
extends ASTECNode
implements ASTNumericLiteral,
ASTLiteralsNode {
    protected String source;

    protected ASTDoubleLiteral() {
    }

    protected ASTDoubleLiteral(String source) {
        this.setSource(source);
    }

    public double getValue() {
        try {
            return LiteralsHelper.getInstance().decodeDouble(this.getSource());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public void accept(LiteralsVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_666 Parameter 'visitor' must not be null.");
        visitor.handle(this);
    }

    public void accept(LexicalsVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_052 Parameter 'visitor' must not be null.");
        if (visitor instanceof LiteralsVisitor) {
            this.accept((LiteralsVisitor)visitor);
        } else {
            Log.error((String)"0xA7000_081AST node type ASTDoubleLiteral of the sub language de.monticore.literals.Literals expected a visitor of type de.monticore.literals.literals._visitor.LiteralsVisitor, but got de.monticore.lexicals.lexicals._visitor.LexicalsVisitor. Visitors of a super language may not be used on ASTs containing nodes of the sub language. Use a visitor of the sub language.");
        }
    }

    @Override
    public boolean deepEquals(Object o, boolean forceSameOrder) {
        Log.errorIfNull((Object)o, (String)"0xA7006_603 Parameter 'o' must not be null.");
        if (!(o instanceof ASTDoubleLiteral)) {
            return false;
        }
        ASTDoubleLiteral comp = (ASTDoubleLiteral)o;
        return this.equalAttributes(comp);
    }

    @Override
    public boolean deepEquals(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_918 Parameter 'o' must not be null.");
        return this.deepEquals(o, true);
    }

    @Override
    public boolean deepEqualsWithComments(Object o, boolean forceSameOrder) {
        Log.errorIfNull((Object)o, (String)"0xA7006_729 Parameter 'o' must not be null.");
        if (!(o instanceof ASTDoubleLiteral)) {
            return false;
        }
        ASTDoubleLiteral comp = (ASTDoubleLiteral)o;
        return this.equalsWithComments(comp);
    }

    @Override
    public boolean deepEqualsWithComments(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_568 Parameter 'o' must not be null.");
        return this.deepEqualsWithComments(o, true);
    }

    public boolean equalAttributes(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_357 Parameter 'o' must not be null.");
        if (!(o instanceof ASTDoubleLiteral)) {
            return false;
        }
        ASTDoubleLiteral comp = (ASTDoubleLiteral)o;
        return (this.source != null || comp.source == null) && (this.source == null || this.source.equals(comp.source));
    }

    @Override
    public boolean equalsWithComments(Object o) {
        Iterator two;
        Iterator one;
        Log.errorIfNull((Object)o, (String)"0xA7006_519 Parameter 'o' must not be null.");
        if (!(o instanceof ASTDoubleLiteral)) {
            return false;
        }
        ASTDoubleLiteral comp = (ASTDoubleLiteral)o;
        if (!this.equalAttributes(comp)) {
            return false;
        }
        if (this.get_PreComments().size() == comp.get_PreComments().size()) {
            one = this.get_PreComments().iterator();
            two = comp.get_PreComments().iterator();
            while (one.hasNext()) {
                if (((Comment)one.next()).equals(two.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.get_PostComments().size() == comp.get_PostComments().size()) {
            one = this.get_PostComments().iterator();
            two = comp.get_PostComments().iterator();
            while (one.hasNext()) {
                if (((Comment)one.next()).equals(two.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public Collection<ASTNode> get_Children() {
        LinkedList<ASTNode> result = new LinkedList<ASTNode>();
        return result;
    }

    public void remove_Child(ASTNode child) {
        Log.errorIfNull((Object)child, (String)"0xA7006_485 Parameter 'child' must not be null.");
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    @Override
    public ASTDoubleLiteral deepClone() {
        return this.deepClone(this._construct());
    }

    public ASTDoubleLiteral deepClone(ASTDoubleLiteral result) {
        Log.errorIfNull((Object)result, (String)"0xA7006_961 Parameter 'result' must not be null.");
        super.deepClone((ASTNode)result);
        result.source = this.source;
        return result;
    }

    protected ASTDoubleLiteral _construct() {
        return new ASTDoubleLiteral();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        Log.errorIfNull((Object)source, (String)"0xA7006_052 Parameter 'source' must not be null.");
        String oldSource = this.source;
        this.source = source;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldSource, (Object)source));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSource();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setSource((String)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setSource(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getSource() != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int featureID, Class<?> baseClass) {
        Log.errorIfNull(baseClass, (String)"0xA7006_786 Parameter 'baseClass' must not be null.");
        return super.eBaseStructuralFeatureID(featureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int featureID, Class<?> baseClass) {
        Log.errorIfNull(baseClass, (String)"0xA7006_210 Parameter 'baseClass' must not be null.");
        return super.eDerivedStructuralFeatureID(featureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(this.getClass().getSimpleName());
        result.append(" Source: ");
        result.append(this.source);
        return result.toString();
    }

    protected EClass eStaticClass() {
        return LiteralsPackage.Literals.ASTDoubleLiteral;
    }

    public static class Builder {
        protected String source;

        public ASTDoubleLiteral build() {
            return new ASTDoubleLiteral(this.source);
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }
    }
}

