/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.literals;

import java.io.CharConversionException;

public class LiteralsHelper {
    private static LiteralsHelper instance;

    private LiteralsHelper() {
    }

    public static LiteralsHelper getInstance() {
        if (instance == null) {
            instance = new LiteralsHelper();
        }
        return instance;
    }

    public char decodeChar(String s) throws CharConversionException {
        if (s.length() == 1) {
            return s.charAt(0);
        }
        if (s.length() == 2 && s.charAt(0) == '\\') {
            switch (s.charAt(1)) {
                case 'b': {
                    return '\b';
                }
                case 't': {
                    return '\t';
                }
                case 'n': {
                    return '\n';
                }
                case 'f': {
                    return '\f';
                }
                case 'r': {
                    return '\r';
                }
                case '\"': {
                    return '\"';
                }
                case '\'': {
                    return '\'';
                }
                case '\\': {
                    return '\\';
                }
            }
        } else if (s.charAt(0) == '\\' && s.charAt(1) == 'u') {
            return (char)Integer.parseInt(s.substring(2), 16);
        }
        throw new CharConversionException("0xA4080 Unable to convert String " + s + " to char.");
    }

    public String decodeString(String s) throws CharConversionException {
        StringBuilder ret = new StringBuilder();
        String in = s;
        while (in.length() != 0) {
            if (in.charAt(0) == '\\') {
                if (in.charAt(1) == 'u') {
                    ret.append(this.decodeChar(in.substring(0, 6)));
                    in = in.substring(6);
                    continue;
                }
                ret.append(this.decodeChar(in.substring(0, 2)));
                in = in.substring(2);
                continue;
            }
            ret.append(in.charAt(0));
            in = in.substring(1);
        }
        return ret.toString();
    }

    public int decodeInt(String s) {
        int radix = 10;
        if (s.startsWith("0") && s.length() > 1) {
            if (s.startsWith("0x") || s.startsWith("0X")) {
                return Integer.parseInt(s.substring(2), 16);
            }
            radix = 8;
        }
        return Integer.parseInt(s, radix);
    }

    public long decodeLong(String s) {
        int radix = 10;
        String in = s;
        if (s.startsWith("0") && s.length() > 2) {
            if (s.startsWith("0x") || s.startsWith("0X")) {
                radix = 16;
                in = s.substring(2);
            } else {
                radix = 8;
            }
        }
        return Long.parseLong(in.substring(0, in.length() - 1), radix);
    }

    public float decodeFloat(String s) {
        if (s.toLowerCase().startsWith("0xp")) {
            return Float.parseFloat("0x0p" + s.substring(3));
        }
        return Float.parseFloat(s);
    }

    public double decodeDouble(String s) {
        if (s.toLowerCase().startsWith("0xp")) {
            return Double.parseDouble("0x0p" + s.substring(3));
        }
        return Double.parseDouble(s);
    }
}

