/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.common.prettyprint;

import de.monticore.common.common._ast.ASTCardinality;
import de.monticore.common.common._ast.ASTCompleteness;
import de.monticore.common.common._ast.ASTModifier;
import de.monticore.common.common._ast.ASTStereoValue;
import de.monticore.common.common._ast.ASTStereotype;
import de.monticore.common.common._visitor.CommonVisitor;
import de.monticore.prettyprint.IndentPrinter;
import de.monticore.types.prettyprint.TypesPrettyPrinterConcreteVisitor;

public class CommonPrettyPrinterConcreteVisitor
extends TypesPrettyPrinterConcreteVisitor
implements CommonVisitor {
    private CommonVisitor realThis = this;

    public CommonPrettyPrinterConcreteVisitor(IndentPrinter printer) {
        super(printer);
    }

    @Override
    public void handle(ASTStereotype a) {
        this.getPrinter().print((Object)"<<");
        String sep = "";
        for (ASTStereoValue value : a.getValues()) {
            this.getPrinter().print((Object)sep);
            value.accept(this.getRealThis());
            sep = ", ";
        }
        this.getPrinter().print((Object)">>");
    }

    @Override
    public void handle(ASTStereoValue a) {
        this.getPrinter().print((Object)a.getName());
        if (a.getSource().isPresent()) {
            this.getPrinter().print((Object)(" = " + a.getSource().get()));
        }
    }

    @Override
    public void handle(ASTCardinality a) {
        this.getPrinter().print((Object)"[");
        if (a.isMany()) {
            this.getPrinter().print((Object)"*");
        } else {
            this.getPrinter().print((Object)a.getLowerBound());
            if (a.getLowerBound() != a.getUpperBound() || a.isNoUpperLimit()) {
                this.getPrinter().print((Object)"..");
                if (a.isNoUpperLimit()) {
                    this.getPrinter().print((Object)"*");
                } else {
                    this.getPrinter().print((Object)a.getUpperBound());
                }
            }
        }
        this.getPrinter().print((Object)"]");
    }

    @Override
    public void handle(ASTCompleteness a) {
        if (a.isComplete()) {
            this.printer.print((Object)"(c) ");
        } else if (a.isIncomplete()) {
            this.printer.print((Object)"(...) ");
        } else if (a.isLeftComplete()) {
            this.printer.print((Object)"(c,...) ");
        } else if (a.isRightComplete()) {
            this.printer.print((Object)"(...,c) ");
        }
    }

    @Override
    public void handle(ASTModifier a) {
        if (a.getStereotype().isPresent()) {
            a.getStereotype().get().accept(this.getRealThis());
            this.getPrinter().print((Object)" ");
        }
        if (a.isPublic()) {
            this.getPrinter().print((Object)"public ");
        }
        if (a.isPrivate()) {
            this.getPrinter().print((Object)"private ");
        }
        if (a.isProtected()) {
            this.getPrinter().print((Object)"protected ");
        }
        if (a.isFinal()) {
            this.getPrinter().print((Object)"final ");
        }
        if (a.isAbstract()) {
            this.getPrinter().print((Object)"abstract ");
        }
        if (a.isLocal()) {
            this.getPrinter().print((Object)"local ");
        }
        if (a.isDerived()) {
            this.getPrinter().print((Object)"derived ");
        }
        if (a.isReadonly()) {
            this.getPrinter().print((Object)"readonly ");
        }
        if (a.isStatic()) {
            this.getPrinter().print((Object)"static ");
        }
    }

    @Override
    public void setRealThis(CommonVisitor realThis) {
        this.realThis = realThis;
    }

    @Override
    public CommonVisitor getRealThis() {
        return this.realThis;
    }
}

