/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.common.common._visitor;

import de.monticore.common.common._ast.ASTCardinality;
import de.monticore.common.common._ast.ASTCommonNode;
import de.monticore.common.common._ast.ASTCompleteness;
import de.monticore.common.common._ast.ASTModifier;
import de.monticore.common.common._ast.ASTStereoValue;
import de.monticore.common.common._ast.ASTStereotype;
import de.monticore.common.common._visitor.CommonVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;

public abstract class CommonParentAwareVisitor
implements CommonVisitor {
    final Stack<ASTCommonNode> parents = new Stack();

    public Optional<ASTCommonNode> getParent() {
        if (!this.parents.isEmpty()) {
            ASTCommonNode topElement = this.parents.peek();
            return Optional.of(topElement);
        }
        return Optional.empty();
    }

    public List<ASTCommonNode> getParents() {
        return new ArrayList<ASTCommonNode>(this.parents);
    }

    @Override
    public void traverse(ASTStereotype node) {
        this.parents.push(node);
        CommonVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTStereoValue node) {
        this.parents.push(node);
        CommonVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTCardinality node) {
        this.parents.push(node);
        CommonVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTCompleteness node) {
        this.parents.push(node);
        CommonVisitor.super.traverse(node);
        this.parents.pop();
    }

    @Override
    public void traverse(ASTModifier node) {
        this.parents.push(node);
        CommonVisitor.super.traverse(node);
        this.parents.pop();
    }
}

