/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.common.common._od;

import de.monticore.ast.ASTNode;
import de.monticore.common.common._ast.ASTCardinality;
import de.monticore.common.common._ast.ASTCommonNode;
import de.monticore.common.common._ast.ASTCompleteness;
import de.monticore.common.common._ast.ASTModifier;
import de.monticore.common.common._ast.ASTStereoValue;
import de.monticore.common.common._ast.ASTStereotype;
import de.monticore.common.common._visitor.CommonVisitor;
import de.monticore.generating.templateengine.reporting.commons.ReportingRepository;
import de.monticore.prettyprint.IndentPrinter;
import de.monticore.symboltable.Scope;
import de.monticore.symboltable.Symbol;
import de.se_rwth.commons.Names;
import de.se_rwth.commons.StringTransformations;
import java.util.Iterator;

public class Common2OD
implements CommonVisitor {
    private CommonVisitor realThis = this;
    protected IndentPrinter pp;
    protected ReportingRepository reporting;
    protected boolean printEmptyOptional = false;
    protected boolean printEmptyList = false;

    public Common2OD(IndentPrinter printer, ReportingRepository reporting) {
        this.reporting = reporting;
        this.pp = printer;
    }

    @Override
    public void handle(ASTStereotype node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.common.common._ast.ASTStereotype");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        Iterator<ASTStereoValue> iter_values = node.getValues().iterator();
        boolean isEmpty = true;
        if (iter_values.hasNext()) {
            this.pp.print((Object)"values");
            this.pp.print((Object)" = [");
            this.pp.println((Object)("// *size: " + node.getValues().size()));
            this.pp.indent();
            isEmpty = false;
        } else if (this.printEmptyList) {
            this.pp.print((Object)"values");
            this.pp.println((Object)" = [];");
        }
        boolean isFirst = true;
        while (iter_values.hasNext()) {
            if (!isFirst) {
                this.pp.println((Object)",");
            }
            isFirst = false;
            iter_values.next().accept(this.getRealThis());
        }
        if (!isEmpty) {
            this.pp.println((Object)"];");
            this.pp.unindent();
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTStereoValue node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.common.common._ast.ASTStereoValue");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("name", "\"" + String.valueOf(node.getName()) + "\"");
        if (node.getSource().isPresent()) {
            this.printAttribute("source", "\"" + String.valueOf(node.getSource().get()) + "\"");
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"source = Optional.Empty;");
        }
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTCardinality node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.common.common._ast.ASTCardinality");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("lowerBound", String.valueOf(node.getLowerBound()));
        this.printAttribute("upperBound", String.valueOf(node.getUpperBound()));
        if (node.getLowerBoundLit().isPresent()) {
            this.pp.print((Object)"lowerBoundLit");
            this.pp.print((Object)" = ");
            node.getLowerBoundLit().get().accept(this.getRealThis());
            this.pp.println((Object)";");
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"lowerBoundLit = Optional.Empty;");
        }
        if (node.getUpperBoundLit().isPresent()) {
            this.pp.print((Object)"upperBoundLit");
            this.pp.print((Object)" = ");
            node.getUpperBoundLit().get().accept(this.getRealThis());
            this.pp.println((Object)";");
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"upperBoundLit = Optional.Empty;");
        }
        this.printAttribute("many", String.valueOf(node.isMany()));
        this.printAttribute("noUpperLimit", String.valueOf(node.isNoUpperLimit()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTCompleteness node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.common.common._ast.ASTCompleteness");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        this.printAttribute("complete", String.valueOf(node.isComplete()));
        this.printAttribute("incomplete", String.valueOf(node.isIncomplete()));
        this.printAttribute("rightComplete", String.valueOf(node.isRightComplete()));
        this.printAttribute("leftComplete", String.valueOf(node.isLeftComplete()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    @Override
    public void handle(ASTModifier node) {
        String scopeName;
        String name = StringTransformations.uncapitalize((String)this.reporting.getASTNodeNameFormatted((ASTNode)node));
        this.printObject(name, "de.monticore.common.common._ast.ASTModifier");
        this.pp.indent();
        if (node.getSymbol().isPresent()) {
            String symName = StringTransformations.uncapitalize((String)this.reporting.getSymbolNameFormatted((Symbol)node.getSymbol().get()));
            this.pp.println((Object)("symbol = " + symName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"symbol = Optional.Empty;");
        }
        if (node.getEnclosingScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getEnclosingScope().get()));
            this.pp.println((Object)("enclosingScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"enclosingScope = Optional.Empty;");
        }
        if (node.getSpannedScope().isPresent()) {
            scopeName = StringTransformations.uncapitalize((String)this.reporting.getScopeNameFormatted((Scope)node.getSpannedScope().get()));
            this.pp.println((Object)("spanningScope = " + scopeName + ";"));
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"spannedScope = Optional.Empty;");
        }
        if (node.getStereotype().isPresent()) {
            this.pp.print((Object)"stereotype");
            this.pp.print((Object)" = ");
            node.getStereotype().get().accept(this.getRealThis());
            this.pp.println((Object)";");
        } else if (this.printEmptyOptional) {
            this.pp.println((Object)"stereotype = Optional.Empty;");
        }
        this.printAttribute("r__public", String.valueOf(node.isPublic()));
        this.printAttribute("r__private", String.valueOf(node.isPrivate()));
        this.printAttribute("r__protected", String.valueOf(node.isProtected()));
        this.printAttribute("r__final", String.valueOf(node.isFinal()));
        this.printAttribute("r__abstract", String.valueOf(node.isAbstract()));
        this.printAttribute("r__local", String.valueOf(node.isLocal()));
        this.printAttribute("r__derived", String.valueOf(node.isDerived()));
        this.printAttribute("r__readonly", String.valueOf(node.isReadonly()));
        this.printAttribute("r__static", String.valueOf(node.isStatic()));
        this.pp.unindent();
        this.pp.print((Object)"}");
    }

    private void printAttribute(String name, String value) {
        this.pp.print((Object)name);
        this.pp.print((Object)" = ");
        this.pp.print((Object)value);
        this.pp.println((Object)";");
    }

    private void printObject(String objName, String objType) {
        this.pp.print((Object)objName);
        this.pp.print((Object)":");
        this.pp.print((Object)Names.getSimpleName((String)objType));
        this.pp.println((Object)" {");
    }

    public String printObjectDiagram(String modelName, ASTCommonNode node) {
        this.pp.clearBuffer();
        this.pp.setIndentLength(2);
        this.pp.print((Object)"objectdiagram ");
        this.pp.print((Object)modelName);
        this.pp.println((Object)" {");
        this.pp.indent();
        node.accept(this.getRealThis());
        this.pp.unindent();
        this.pp.println((Object)"}");
        return this.pp.getContent();
    }

    @Override
    public void setRealThis(CommonVisitor realThis) {
        this.realThis = realThis;
    }

    @Override
    public CommonVisitor getRealThis() {
        return this.realThis;
    }

    public boolean isPrintEmptyOptional() {
        return this.printEmptyOptional;
    }

    public void setPrintEmptyOptional(boolean printEmptyOptional) {
        this.printEmptyOptional = printEmptyOptional;
    }

    public boolean isPrintEmptyList() {
        return this.printEmptyList;
    }

    public void setPrintEmptyList(boolean printEmptyList) {
        this.printEmptyList = printEmptyList;
    }
}

