/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.common.common._ast;

import de.monticore.ast.ASTNode;
import de.monticore.ast.Comment;
import de.monticore.common.common._ast.ASTCommonNode;
import de.monticore.common.common._ast.CommonPackage;
import de.monticore.common.common._visitor.CommonVisitor;
import de.monticore.emf._ast.ASTECNode;
import de.monticore.lexicals.lexicals._visitor.LexicalsVisitor;
import de.monticore.literals.LiteralsHelper;
import de.monticore.literals.literals._visitor.LiteralsVisitor;
import de.monticore.types.types._visitor.TypesVisitor;
import de.se_rwth.commons.logging.Log;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class ASTStereoValue
extends ASTECNode
implements ASTCommonNode {
    protected String name;
    protected Optional<String> source = Optional.empty();

    protected ASTStereoValue() {
    }

    protected ASTStereoValue(String name, String source) {
        this.setName(name);
        this.setSource(source);
    }

    public String getValue() {
        try {
            if (this.source.isPresent()) {
                return LiteralsHelper.getInstance().decodeString(this.source.get());
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setValue(String value) {
        Log.errorIfNull((Object)value, (String)"0xA7006_000 Parameter 'value' must not be null.");
        this.source = Optional.of('\"' + value + '\"');
    }

    @Override
    public void accept(CommonVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_193 Parameter 'visitor' must not be null.");
        visitor.handle(this);
    }

    public void accept(TypesVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_726 Parameter 'visitor' must not be null.");
        if (visitor instanceof CommonVisitor) {
            this.accept((CommonVisitor)visitor);
        } else {
            Log.error((String)"0xA7000_847AST node type ASTStereoValue of the sub language de.monticore.common.Common expected a visitor of type de.monticore.common.common._visitor.CommonVisitor, but got de.monticore.types.types._visitor.TypesVisitor. Visitors of a super language may not be used on ASTs containing nodes of the sub language. Use a visitor of the sub language.");
        }
    }

    public void accept(LiteralsVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_084 Parameter 'visitor' must not be null.");
        if (visitor instanceof CommonVisitor) {
            this.accept((CommonVisitor)visitor);
        } else {
            Log.error((String)"0xA7000_763AST node type ASTStereoValue of the sub language de.monticore.common.Common expected a visitor of type de.monticore.common.common._visitor.CommonVisitor, but got de.monticore.literals.literals._visitor.LiteralsVisitor. Visitors of a super language may not be used on ASTs containing nodes of the sub language. Use a visitor of the sub language.");
        }
    }

    public void accept(LexicalsVisitor visitor) {
        Log.errorIfNull((Object)visitor, (String)"0xA7006_301 Parameter 'visitor' must not be null.");
        if (visitor instanceof CommonVisitor) {
            this.accept((CommonVisitor)visitor);
        } else {
            Log.error((String)"0xA7000_949AST node type ASTStereoValue of the sub language de.monticore.common.Common expected a visitor of type de.monticore.common.common._visitor.CommonVisitor, but got de.monticore.lexicals.lexicals._visitor.LexicalsVisitor. Visitors of a super language may not be used on ASTs containing nodes of the sub language. Use a visitor of the sub language.");
        }
    }

    public boolean deepEquals(Object o, boolean forceSameOrder) {
        Log.errorIfNull((Object)o, (String)"0xA7006_275 Parameter 'o' must not be null.");
        if (!(o instanceof ASTStereoValue)) {
            return false;
        }
        ASTStereoValue comp = (ASTStereoValue)o;
        return this.equalAttributes(comp);
    }

    public boolean deepEquals(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_376 Parameter 'o' must not be null.");
        return this.deepEquals(o, true);
    }

    public boolean deepEqualsWithComments(Object o, boolean forceSameOrder) {
        Log.errorIfNull((Object)o, (String)"0xA7006_481 Parameter 'o' must not be null.");
        if (!(o instanceof ASTStereoValue)) {
            return false;
        }
        ASTStereoValue comp = (ASTStereoValue)o;
        return this.equalsWithComments(comp);
    }

    public boolean deepEqualsWithComments(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_258 Parameter 'o' must not be null.");
        return this.deepEqualsWithComments(o, true);
    }

    public boolean equalAttributes(Object o) {
        Log.errorIfNull((Object)o, (String)"0xA7006_703 Parameter 'o' must not be null.");
        if (!(o instanceof ASTStereoValue)) {
            return false;
        }
        ASTStereoValue comp = (ASTStereoValue)o;
        if (this.name == null && comp.name != null || this.name != null && !this.name.equals(comp.name)) {
            return false;
        }
        return this.source.isPresent() == comp.source.isPresent() && (!this.source.isPresent() || this.source.get().equals(comp.source.get()));
    }

    public boolean equalsWithComments(Object o) {
        Iterator two;
        Iterator one;
        Log.errorIfNull((Object)o, (String)"0xA7006_024 Parameter 'o' must not be null.");
        if (!(o instanceof ASTStereoValue)) {
            return false;
        }
        ASTStereoValue comp = (ASTStereoValue)o;
        if (!this.equalAttributes(comp)) {
            return false;
        }
        if (this.get_PreComments().size() == comp.get_PreComments().size()) {
            one = this.get_PreComments().iterator();
            two = comp.get_PreComments().iterator();
            while (one.hasNext()) {
                if (((Comment)one.next()).equals(two.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        if (this.get_PostComments().size() == comp.get_PostComments().size()) {
            one = this.get_PostComments().iterator();
            two = comp.get_PostComments().iterator();
            while (one.hasNext()) {
                if (((Comment)one.next()).equals(two.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public Collection<ASTNode> get_Children() {
        LinkedList<ASTNode> result = new LinkedList<ASTNode>();
        return result;
    }

    public void remove_Child(ASTNode child) {
        Log.errorIfNull((Object)child, (String)"0xA7006_397 Parameter 'child' must not be null.");
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public ASTStereoValue deepClone() {
        return this.deepClone(this._construct());
    }

    public ASTStereoValue deepClone(ASTStereoValue result) {
        Log.errorIfNull((Object)result, (String)"0xA7006_394 Parameter 'result' must not be null.");
        super.deepClone((ASTNode)result);
        result.name = this.name;
        result.source = this.source.isPresent() ? Optional.ofNullable(this.source.get()) : Optional.empty();
        return result;
    }

    protected ASTStereoValue _construct() {
        return new ASTStereoValue();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public void setName(String name) {
        Log.errorIfNull((Object)name, (String)"0xA7006_635 Parameter 'name' must not be null.");
        String oldName = this.name;
        this.name = name;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)name));
        }
    }

    public void setSource(String source) {
        String oldSource = this.source.isPresent() ? this.source.get() : null;
        this.source = Optional.ofNullable(source);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSource, (Object)source));
        }
    }

    public boolean sourceIsPresent() {
        return this.source.isPresent();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getSource().isPresent() ? this.getSource().get() : null;
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setSource((String)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(null);
                return;
            }
            case 1: {
                this.setSource(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getName() != null;
            }
            case 1: {
                return this.getSource().isPresent();
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int featureID, Class<?> baseClass) {
        Log.errorIfNull(baseClass, (String)"0xA7006_378 Parameter 'baseClass' must not be null.");
        return super.eBaseStructuralFeatureID(featureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int featureID, Class<?> baseClass) {
        Log.errorIfNull(baseClass, (String)"0xA7006_187 Parameter 'baseClass' must not be null.");
        return super.eDerivedStructuralFeatureID(featureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(this.getClass().getSimpleName());
        result.append(" Name: ");
        result.append(this.name);
        if (this.source.isPresent()) {
            result.append(" Source: ");
            result.append(this.source.get());
        }
        return result.toString();
    }

    protected EClass eStaticClass() {
        return CommonPackage.Literals.ASTStereoValue;
    }

    public static class Builder {
        protected String name;
        protected String source;

        public ASTStereoValue build() {
            return new ASTStereoValue(this.name, this.source);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }
    }
}

