/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.mojo.extra;

import com.google.common.collect.Lists;
import de.monticore.mojo.extra.Executable;
import de.monticore.mojo.extra.Execution;
import de.monticore.mojo.extra.ScriptReportRenderer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="script-report", defaultPhase=LifecyclePhase.SITE)
public class ScriptResultReport
extends AbstractMavenReport {
    private static final String OUTPUT_NAME = "script-report";
    @Parameter(property="project.reporting.outputDirectory", required=true, readonly=true)
    private String outputDirectory;
    @Parameter(required=false, defaultValue="${project.build.directory}/scripts")
    private File scriptOutputDirectory;
    @Parameter(required=false)
    private List<File> additionalOutputs;
    @Parameter(required=false)
    private List<Executable> additionalExecutables;
    @Parameter(defaultValue="false", required=false)
    private boolean skipDefaultScripts;
    @Parameter(required=false)
    private Executable detailedErrorList;
    @Parameter(required=false)
    private Executable errorList;
    @Parameter(required=false)
    private Executable findDoubleFileNames;
    @Parameter(required=false)
    private Executable ftlAnalysis;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Component
    private Renderer renderer;

    public String getOutputName() {
        return OUTPUT_NAME;
    }

    public String getName(Locale locale) {
        return "Script Result Report";
    }

    public String getDescription(Locale locale) {
        return "This report contains the results of certain analysis scripts.";
    }

    protected Renderer getSiteRenderer() {
        return this.renderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected File getScriptOutputDirectory() {
        return this.scriptOutputDirectory;
    }

    protected MavenProject getProject() {
        return this.mavenProject;
    }

    protected List<File> getAdditionalOutputs() {
        if (this.additionalOutputs == null) {
            this.additionalOutputs = Lists.newArrayList();
        }
        return this.additionalOutputs;
    }

    protected List<Executable> getAdditionalExecutables() {
        if (this.additionalExecutables == null) {
            this.additionalExecutables = Lists.newArrayList();
        }
        return this.additionalExecutables;
    }

    protected Executable getDetailedErrorList() {
        if (this.detailedErrorList == null) {
            ArrayList arguments = Lists.newArrayList((Object[])new String[]{this.getProject().getBasedir().getPath(), this.getScriptOutputDirectory().getPath().concat("/temp")});
            this.detailedErrorList = new Executable(new File(this.getScriptOutputDirectory(), "bin/detailedErrorList.sh"), arguments);
        }
        return this.detailedErrorList;
    }

    protected Executable getErrorList() {
        if (this.errorList == null) {
            ArrayList arguments = Lists.newArrayList((Object[])new String[]{this.getProject().getBasedir().getPath(), this.getScriptOutputDirectory().getPath().concat("/temp")});
            this.errorList = new Executable(new File(this.getScriptOutputDirectory(), "bin/errorList.sh"), arguments);
        }
        return this.errorList;
    }

    protected Executable getFindDoubleFileNames() {
        if (this.findDoubleFileNames == null) {
            ArrayList arguments = Lists.newArrayList((Object[])new String[]{this.getProject().getBasedir().getPath(), this.getScriptOutputDirectory().getPath().concat("/temp")});
            this.findDoubleFileNames = new Executable(new File(this.getScriptOutputDirectory(), "bin/findDoubleFileNames.sh"), arguments);
        }
        return this.findDoubleFileNames;
    }

    protected Executable getFtlAnalysis() {
        if (this.ftlAnalysis == null) {
            ArrayList arguments = Lists.newArrayList((Object[])new String[]{this.getProject().getBasedir().getPath().concat("/gtr/src").concat(":").concat(this.getProject().getBasedir().getPath().concat("/use/src")), "configure.StartAllOutput", this.getScriptOutputDirectory().getPath().concat("/temp/ftlAnalysis.tmp")});
            this.ftlAnalysis = new Executable(new File(this.getScriptOutputDirectory(), "bin/ftlAnalysis.sh"), arguments);
        }
        return this.ftlAnalysis;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.skipDefaultScripts) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                this.getLog().warn((CharSequence)"Script result reports are platform dependant and only work on Linux. Period. Default skripts will be skipped.");
            } else {
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                File tempDir = new File(this.getScriptOutputDirectory(), "temp");
                File binDir = new File(this.getScriptOutputDirectory(), "bin");
                File doubleNames = new File(binDir, "findDoubleFileNames.JavaStandardNames.txt");
                File detailScript = new File(binDir, "detailedErrorList.sh");
                File errorScript = new File(binDir, "errorList.sh");
                File doubleScript = new File(binDir, "findDoubleFileNames.sh");
                File ftlScript = new File(binDir, "ftlAnalysis.sh");
                tempDir.mkdirs();
                binDir.mkdirs();
                this.writeStreamToFile(loader.getResourceAsStream("util/findDoubleFileNames.JavaStandardNames.txt"), doubleNames);
                this.writeStreamToFile(loader.getResourceAsStream("scripts/detailedErrorList.sh"), detailScript);
                this.writeStreamToFile(loader.getResourceAsStream("scripts/errorList.sh"), errorScript);
                this.writeStreamToFile(loader.getResourceAsStream("scripts/findDoubleFileNames.sh"), doubleScript);
                this.writeStreamToFile(loader.getResourceAsStream("scripts/ftlAnalysis.sh"), ftlScript);
                detailScript.setExecutable(true);
                errorScript.setExecutable(true);
                doubleScript.setExecutable(true);
                ftlScript.setExecutable(true);
                this.getLog().debug((CharSequence)"Executing default scripts:");
                this.getLog().info((CharSequence)("Executing script " + this.getDetailedErrorList().getPathToExecutable()));
                this.getLog().debug((CharSequence)this.getDetailedErrorList().toString());
                this.getAdditionalOutputs().add(new Execution(this.getDetailedErrorList(), this.getScriptOutputDirectory(), this.getLog()).execute());
                this.getLog().debug((CharSequence)("Executed script " + this.getDetailedErrorList().getPathToExecutable()));
                this.getLog().info((CharSequence)("Executing script " + this.getErrorList().getPathToExecutable()));
                this.getLog().debug((CharSequence)this.getErrorList().toString());
                this.getAdditionalOutputs().add(new Execution(this.getErrorList(), this.getScriptOutputDirectory(), this.getLog()).execute());
                this.getLog().debug((CharSequence)("Executed script " + this.getErrorList().getPathToExecutable()));
                this.getLog().info((CharSequence)("Executing script " + this.getFindDoubleFileNames().getPathToExecutable()));
                this.getLog().debug((CharSequence)this.getFindDoubleFileNames().toString());
                this.getAdditionalOutputs().add(new Execution(this.getFindDoubleFileNames(), this.getScriptOutputDirectory(), this.getLog()).execute());
                this.getLog().debug((CharSequence)("Executed script " + this.getFindDoubleFileNames().getPathToExecutable()));
                this.getLog().info((CharSequence)("Executing script " + this.getFtlAnalysis().getPathToExecutable()));
                this.getLog().debug((CharSequence)this.getFtlAnalysis().toString());
                this.getAdditionalOutputs().add(new Execution(this.getFtlAnalysis(), this.getScriptOutputDirectory(), this.getLog()).execute());
                this.getLog().debug((CharSequence)("Executed script " + this.getFtlAnalysis().getPathToExecutable()));
            }
        }
        if (!this.getAdditionalExecutables().isEmpty() && System.getProperty("os.name").startsWith("Windows")) {
            this.getLog().warn((CharSequence)"Script result reports are platform dependant and only work on Linux. Period. Additional scripts will be skipped.");
        } else {
            this.getLog().debug((CharSequence)"Executing additional scripts:");
            for (Executable executable : this.getAdditionalExecutables()) {
                this.getLog().info((CharSequence)"Executing script:");
                this.getLog().debug((CharSequence)executable.toString());
                this.getAdditionalOutputs().add(new Execution(executable, this.getScriptOutputDirectory(), this.getLog()).execute());
                this.getLog().debug((CharSequence)("Executed script " + executable.getPathToExecutable()));
            }
        }
        this.getLog().debug((CharSequence)"Rendering report sites.");
        new ScriptReportRenderer(this.getSink(), this.getAdditionalOutputs(), this.getOutputDirectory(), this.getSinkFactory(), this.getLog()).render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamToFile(InputStream stream, File file) {
        if (stream == null) {
            throw new IllegalArgumentException("0xA4087 Argument stream must not be null!");
        }
        if (file == null) {
            throw new IllegalArgumentException("0xA4088 Argument file must not be null!");
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            int read = stream.read();
            while (read != -1) {
                output.write(read);
                read = stream.read();
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }
}

