/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.mojo.extra;

import com.google.common.collect.Lists;
import de.monticore.mojo.ReportRenderer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.AbstractMavenReportRenderer;

public class ScriptReportRenderer
extends AbstractMavenReportRenderer {
    private List<File> inputFiles = Lists.newArrayList();
    private String outputDirectory;
    private SinkFactory sinkFactory;
    private Log log;

    public ScriptReportRenderer(Sink sink, List<File> inputFiles, String outputDirectory, SinkFactory sinkFactory, Log log) {
        super(sink);
        this.inputFiles = inputFiles;
        this.outputDirectory = outputDirectory;
        this.sinkFactory = sinkFactory;
        this.log = log;
    }

    public String getTitle() {
        return "Script Result Report";
    }

    protected void renderBody() {
        this.startSection("Script Result Report");
        this.paragraph("The following subpages contain the results of each analysis script.");
        this.startTable();
        for (File inputFile : this.inputFiles) {
            this.tableRow(new String[]{ScriptReportRenderer.createLinkPatternedText((String)inputFile.getName(), (String)("./" + inputFile.getName() + ".html")), "Results of script " + inputFile.getName()});
            try {
                new ReportRenderer(this.sinkFactory.createSink(new File(this.outputDirectory), inputFile.getName().concat(".html")), inputFile, inputFile.getName(), "script-report", this.log).render();
            }
            catch (IOException e) {
                this.log.error((CharSequence)"0xA4070 Could not create sink for ".concat(new File(this.outputDirectory, inputFile.getName().concat(".html")).getPath()), (Throwable)e);
            }
        }
        this.endTable();
        this.endSection();
    }
}

