/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.mojo.extra;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import de.monticore.mojo.extra.Executable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;

public class Execution {
    Log log;
    File outputDirectory;
    Executable executable;

    public Execution(Executable executable, File outputDirectory, Log log) {
        if (executable == null) {
            throw new IllegalArgumentException("0xA4084 Executable must not be null!");
        }
        if (outputDirectory == null) {
            throw new IllegalArgumentException("0xA4085 Output directory must not be null!");
        }
        if (log == null) {
            throw new IllegalArgumentException("0xA4086 Log must not be null!");
        }
        this.executable = executable;
        this.outputDirectory = outputDirectory;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File execute() {
        ArrayList execution = Lists.newArrayList();
        execution.add(this.executable.getPathToExecutable().getPath());
        execution.addAll(this.executable.getArguments());
        ProcessBuilder processBuilder = new ProcessBuilder(execution);
        File result = new File(this.outputDirectory, Files.getNameWithoutExtension((String)this.executable.getPathToExecutable().getName()));
        processBuilder.redirectErrorStream(true);
        FileOutputStream resultWriter = null;
        try {
            Process process = processBuilder.start();
            resultWriter = new FileOutputStream(result);
            InputStream processOutput = process.getInputStream();
            int read = processOutput.read();
            while (read != -1) {
                resultWriter.write(read);
                read = processOutput.read();
            }
            if (process.waitFor() != 0) {
                this.log.error((CharSequence)("0xA4060 Execution of script " + this.executable.getPathToExecutable().getName() + " returned " + process.exitValue()));
            }
        }
        catch (IOException e) {
            this.log.warn((Throwable)e);
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
        finally {
            try {
                if (resultWriter != null) {
                    resultWriter.close();
                }
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
        return result;
    }
}

