/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.mojo.extra;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public class Executable {
    File pathToExecutable;
    List<String> arguments = Lists.newArrayList();

    public Executable() {
    }

    public Executable(File pathToExecutable) {
        this.setPathToExecutable(pathToExecutable);
    }

    public Executable(File pathToExecutable, List<String> arguments) {
        this(pathToExecutable);
        this.setArguments(arguments);
    }

    public File getPathToExecutable() {
        return this.pathToExecutable;
    }

    public List<String> getArguments() {
        return ImmutableList.copyOf(this.arguments);
    }

    void setPathToExecutable(File pathToExecutable) {
        if (pathToExecutable == null) {
            throw new IllegalArgumentException("0xA4082 Path to executable must not be null!");
        }
        this.pathToExecutable = pathToExecutable;
    }

    void setArguments(List<String> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("0xA4083 Arguments must not be null!");
        }
        this.arguments = arguments;
    }

    public String toString() {
        String result = "Executable: ".concat(this.pathToExecutable.getAbsolutePath()).concat(" ");
        result = result.concat("Arguments: ");
        for (String arg : this.arguments) {
            result = result.concat(arg).concat(" ");
        }
        return result;
    }
}

