/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.mojo;

import de.monticore.mojo.ReportRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.AbstractMavenReportRenderer;

public class ReportsRenderer
extends AbstractMavenReportRenderer {
    private Map<String, List<Path>> inputFiles;
    private String outputDirectory;
    private SinkFactory sinkFactory;
    private Log log;

    public ReportsRenderer(Sink sink, Map<String, List<Path>> inputFiles, String outputDirectory, SinkFactory sinkFactory, Log log) {
        super(sink);
        this.inputFiles = inputFiles;
        this.outputDirectory = outputDirectory;
        this.sinkFactory = sinkFactory;
        this.log = log;
    }

    public String getTitle() {
        return "MontiCore Reports";
    }

    protected void renderBody() {
        this.startSection("MontiCore Reports");
        this.paragraph("The following subpages contain the reports for each processed grammar.");
        for (Map.Entry<String, List<Path>> entry : this.inputFiles.entrySet()) {
            this.startSection("Reports for " + entry.getKey());
            this.startTable();
            for (Path report : entry.getValue()) {
                File input = report.toFile();
                try {
                    this.tableRow(new String[]{ReportsRenderer.createLinkPatternedText((String)input.getName(), (String)("./" + entry.getKey() + "." + input.getName() + ".html")), "Report " + input.getName()});
                    new ReportRenderer(this.sinkFactory.createSink(new File(this.outputDirectory), entry.getKey() + "." + input.getName().concat(".html")), input, input.getName() + " for " + entry.getKey(), "monticore-reporting", this.log).render();
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"0xA4061 Could not create sink for ".concat(new File(this.outputDirectory, entry.getKey() + "." + input.getName().concat(".html")).getPath()), (Throwable)e);
                }
            }
            this.endTable();
            this.endSection();
        }
        this.endSection();
    }
}

