/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.mojo;

import de.monticore.mojo.ReportsRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="reporting-report", defaultPhase=LifecyclePhase.SITE)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class ReportingReport
extends AbstractMavenReport {
    public static final String OUTPUT_NAME = "monticore-reporting";
    @Parameter(property="project.reporting.outputDirectory", required=true, readonly=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/${plugin.goalPrefix}/sourcecode/reports")
    private File reportsBaseDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Component
    private Renderer renderer;
    protected static final List<String> REPORTS = Arrays.asList("01_Summary.txt", "02_GeneratedFiles.txt", "03_HandwrittenCodeFiles.txt", "04_Templates.txt", "05_HookPoint.txt", "06_Instantiations.txt", "07_Variables.txt", "08_Detailed.txt", "09_TemplateTree.txt", "10_NodeTree.txt", "11_NodeTreeDecorated.txt", "12_TypesOfNodes.txt", "13_SymbolTable.txt", "14_Transformations.txt", "15_ArtifactGml.gml", "16_ArtifactGv.gv", "17_InputOutputFiles.txt", "18_ObjectDiagram.txt");

    public String getOutputName() {
        return OUTPUT_NAME;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected File getReportsBaseDirectory() {
        return this.reportsBaseDirectory;
    }

    protected MavenProject getProject() {
        return this.mavenProject;
    }

    protected Renderer getSiteRenderer() {
        return this.renderer;
    }

    public String getName(Locale locale) {
        return "MontiCore Reporting";
    }

    public String getDescription(Locale locale) {
        return "This report contains the the reports generated by MontiCore.";
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        LinkedHashMap<String, List<Path>> modelReports = new LinkedHashMap();
        try {
            modelReports = Files.walk(this.getReportsBaseDirectory().toPath(), new FileVisitOption[0]).sorted().filter(p -> REPORTS.contains(p.getFileName().toString())).collect(Collectors.groupingBy(p -> p.getParent().getFileName().toString()));
        }
        catch (IOException e2) {
            this.getLog().error((Throwable)e2);
        }
        modelReports.entrySet().forEach(e -> this.getLog().debug((CharSequence)("Reports for " + (String)e.getKey() + ": " + e.getValue())));
        this.getLog().debug((CharSequence)"Rendering reporting sites.");
        new ReportsRenderer(this.getSink(), modelReports, this.getOutputDirectory(), this.getSinkFactory(), this.getLog()).render();
    }

    public boolean canGenerateReport() {
        if (this.getProject().getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"MontiCore reports are not available for POM modules.");
            return false;
        }
        return true;
    }
}

