/*
 * Decompiled with CFR 0.152.
 */
package de.monticore.mojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.monticore.MontiCoreConfiguration;
import de.monticore.MontiCoreScript;
import de.se_rwth.commons.configuration.Configuration;
import de.se_rwth.commons.configuration.ConfigurationPropertiesMapContributor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter
    private List<File> grammars;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/${plugin.goalPrefix}/sourcecode")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/${plugin.goalPrefix}/symboltable")
    private File symbolTableDirectory;
    @Parameter
    private List<File> handcodedPaths;
    @Parameter
    private List<File> templatePaths;
    @Parameter
    private List<File> modelPaths;
    @Parameter
    private List<String> modelPathDependencies;
    @Parameter(defaultValue="true")
    private boolean addGrammarDirectoriesToModelPath = true;
    @Parameter(defaultValue="false")
    private boolean addSourceDirectoriesToModelPath = false;
    @Parameter(defaultValue="false")
    private boolean addClassPathToModelPath = false;
    @Parameter(defaultValue="true")
    private boolean addOutputDirectoryToModelPath = false;
    @Parameter
    private List<String> scopes = ImmutableList.of();
    @Parameter(defaultValue="grammars, grammar, symbols")
    private List<String> classifiers = ImmutableList.of();
    @Parameter
    private String script = null;
    @Parameter
    private Map<String, String> arguments = Collections.emptyMap();
    @Parameter(defaultValue="false")
    private boolean force = false;
    @Parameter(defaultValue="false")
    private boolean skip = false;

    protected MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected Set<File> getGrammars() {
        ImmutableSet grammarFiles;
        ImmutableSet.Builder grammarFilesBuilder = ImmutableSet.builder();
        if (this.grammars != null) {
            this.grammars.forEach(g -> grammarFilesBuilder.add((Object)this.fromBasePath((File)g)));
        }
        return (grammarFiles = grammarFilesBuilder.build()).isEmpty() ? ImmutableSet.of((Object)this.getDefaultGrammarDirectory()) : grammarFiles;
    }

    public File getDefaultGrammarDirectory() {
        return this.fromBasePath("src/main/grammars");
    }

    protected File getOutputDirectory() {
        return this.fromBasePath(this.outputDirectory);
    }

    protected File getSymbolTableDirectory() {
        return this.fromBasePath(this.symbolTableDirectory);
    }

    protected Set<File> getHandcodedPaths() {
        ImmutableSet handcodedPathFiles;
        ImmutableSet.Builder handcodedPathsBuilder = ImmutableSet.builder();
        if (this.handcodedPaths != null) {
            this.handcodedPaths.forEach(t -> handcodedPathsBuilder.add((Object)this.fromBasePath((File)t)));
        }
        return (handcodedPathFiles = handcodedPathsBuilder.build()).isEmpty() ? ImmutableSet.of((Object)this.getDefaultHandcodedPath()) : handcodedPathFiles;
    }

    public File getDefaultHandcodedPath() {
        return this.fromBasePath("src/main/java");
    }

    protected Set<File> getTemplatePaths() {
        ImmutableSet templatePathFiles;
        ImmutableSet.Builder templatePathsBuilder = ImmutableSet.builder();
        if (this.templatePaths != null) {
            this.templatePaths.forEach(t -> templatePathsBuilder.add((Object)this.fromBasePath((File)t)));
        }
        return (templatePathFiles = templatePathsBuilder.build()).isEmpty() ? (Set)this.getDefaultTemplatePath().map(ImmutableSet::of).orElse(ImmutableSet.of()) : templatePathFiles;
    }

    public Optional<File> getDefaultTemplatePath() {
        return Optional.of(this.fromBasePath("src/main/resources")).filter(File::exists);
    }

    protected Set<File> getModelPaths() {
        ImmutableSet.Builder modelPaths = ImmutableSet.builder();
        if (this.modelPaths != null) {
            this.modelPaths.forEach(mP -> modelPaths.add((Object)this.fromBasePath((File)mP)));
        }
        if (this.addGrammarDirectoriesToModelPath()) {
            for (File grammarFile : this.getGrammars()) {
                if (!grammarFile.isDirectory()) continue;
                modelPaths.add((Object)grammarFile);
            }
        }
        if (this.addSourceDirectoriesToModelPath()) {
            this.getMavenProject().getCompileSourceRoots().forEach(csR -> modelPaths.add((Object)new File((String)csR)));
        }
        if (this.addClassPathToModelPath()) {
            try {
                this.getMavenProject().getCompileClasspathElements().forEach(cpDir -> modelPaths.add((Object)new File((String)cpDir)));
            }
            catch (DependencyResolutionRequiredException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        for (Artifact artifact : this.getMavenProject().getArtifacts()) {
            if (this.getModelPathDependencies().contains(this.getArtifactDescription(artifact.getGroupId(), artifact.getArtifactId()))) {
                modelPaths.add((Object)artifact.getFile());
                continue;
            }
            if (!this.getClassifiers().contains(artifact.getClassifier()) || !this.getScopes().isEmpty() && !this.getScopes().contains(artifact.getScope())) continue;
            modelPaths.add((Object)artifact.getFile());
        }
        return modelPaths.build();
    }

    protected List<String> getModelPathDependencies() {
        return (List)MoreObjects.firstNonNull(this.modelPathDependencies, (Object)ImmutableList.of());
    }

    protected boolean addGrammarDirectoriesToModelPath() {
        return this.addGrammarDirectoriesToModelPath;
    }

    protected boolean addSourceDirectoriesToModelPath() {
        return this.addSourceDirectoriesToModelPath;
    }

    protected boolean addClassPathToModelPath() {
        return this.addClassPathToModelPath;
    }

    protected boolean addOutputDirectoryToModelPath() {
        return this.addOutputDirectoryToModelPath;
    }

    protected List<String> getScopes() {
        return this.scopes;
    }

    protected List<String> getClassifiers() {
        return (List)MoreObjects.firstNonNull(this.classifiers, (Object)ImmutableList.builder().add((Object)"grammars").add((Object)"grammar").add((Object)"symbols").build());
    }

    protected String getScript() {
        return this.script;
    }

    protected Map<String, String> getArguments() {
        return this.arguments;
    }

    protected boolean getForce() {
        return this.force;
    }

    protected boolean skip() {
        return this.skip;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        ConfigurationPropertiesMapContributor configuration;
        MontiCoreConfiguration mcConf;
        Iterator grammarPaths;
        if (this.skip()) {
            this.getLog().info((CharSequence)"Plugin execution skipped per configuration.");
            return;
        }
        this.getOutputDirectory().mkdirs();
        this.getSymbolTableDirectory().mkdirs();
        HashMap<String, Collection<String>> parameters = new HashMap<String, Collection<String>>();
        parameters.put(MontiCoreConfiguration.Options.GRAMMARS.toString(), this.toStringSet(this.getGrammars()));
        parameters.put(MontiCoreConfiguration.Options.MODELPATH.toString(), this.toStringSet(this.getModelPaths()));
        parameters.put(MontiCoreConfiguration.Options.HANDCODEDPATH.toString(), this.toStringSet(this.getHandcodedPaths()));
        parameters.put(MontiCoreConfiguration.Options.TEMPLATEPATH.toString(), this.toStringSet(this.getTemplatePaths()));
        parameters.put(MontiCoreConfiguration.Options.OUT.toString(), Arrays.asList(this.getOutputDirectory().getAbsolutePath()));
        parameters.put(MontiCoreConfiguration.Options.OUTTOMODELPATH.toString(), Arrays.asList(Boolean.toString(this.addOutputDirectoryToModelPath())));
        if (this.getForce()) {
            parameters.put(MontiCoreConfiguration.Options.FORCE.toString(), new ArrayList());
        }
        if (!(grammarPaths = (mcConf = MontiCoreConfiguration.withConfiguration((Configuration)(configuration = ConfigurationPropertiesMapContributor.fromSplitMap(parameters)))).getGrammars().getResolvedPaths()).hasNext()) {
            this.getLog().warn((CharSequence)"0xA1035 Skipping MontiCore as there are no \".mc4\" files in the input parameter. Check your \"grammars\" parameter configuration.");
            return;
        }
        if (this.getScript() == null) {
            new MontiCoreScript().run((Configuration)configuration);
        } else {
            try {
                String script = null;
                ClassLoader l = ((Object)((Object)this)).getClass().getClassLoader();
                URL r = l.getResource(this.getScript());
                if (r == null) {
                    r = this.fromBasePath(this.getScript()).toURI().toURL();
                }
                Scanner scr = new Scanner(r.openStream());
                script = scr.useDelimiter("\\A").next();
                scr.close();
                this.getArguments().forEach((key, value) -> {
                    Iterable cfr_ignored_0 = parameters.put((String)key, (Collection<String>)Arrays.asList(value.split(" ")));
                });
                configuration = ConfigurationPropertiesMapContributor.fromSplitMap(parameters);
                this.getLog().debug((CharSequence)"Configuration content:");
                configuration.getAllValues().forEach((key, value) -> this.getLog().debug((CharSequence)("Key: " + key + " -> " + value.toString())));
                new MontiCoreScript().run(script, (Configuration)configuration);
            }
            catch (IOException e) {
                throw new MojoFailureException("0xA4089 Failed to load the specified script.", (Throwable)e);
            }
        }
        this.getMavenProject().addCompileSourceRoot(this.getOutputDirectory().getPath());
        this.getLog().debug((CharSequence)("Adding compile source root: " + this.getOutputDirectory().getPath()));
    }

    protected File fromBasePath(File file) {
        return this.fromBasePath(file.getPath());
    }

    protected File fromBasePath(String filePath) {
        File file = new File(filePath);
        return !file.isAbsolute() ? new File(this.getMavenProject().getBasedir(), filePath) : file;
    }

    protected String getArtifactDescription(String groupId, String artifactId) {
        return groupId.trim() + ":" + artifactId.trim();
    }

    protected Set<String> toStringSet(Collection<File> files) {
        return ImmutableSet.builder().addAll(Iterables.transform(files, file -> file.getPath())).build();
    }
}

