/*
 * Decompiled with CFR 0.152.
 */
package de.se_rwth.commons.logging;

import de.se_rwth.commons.SourcePosition;
import de.se_rwth.commons.logging.Finding;
import de.se_rwth.commons.logging.Log;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class Slf4jLog
extends Log {
    ILoggerFactory factory = LoggerFactory.getILoggerFactory();

    public static final void init() {
        Slf4jLog.setLog(new Slf4jLog());
    }

    protected Slf4jLog() {
    }

    @Override
    protected boolean doIsTraceEnabled(String logName) {
        return this.factory.getLogger(logName).isTraceEnabled();
    }

    @Override
    protected void doTrace(String msg, String logName) {
        this.factory.getLogger(logName).trace(msg);
    }

    @Override
    protected void doTrace(String msg, Throwable t, String logName) {
        this.factory.getLogger(logName).trace(msg, t);
    }

    @Override
    protected boolean doIsDebugEnabled(String logName) {
        return this.factory.getLogger(logName).isDebugEnabled();
    }

    @Override
    protected void doDebug(String msg, String logName) {
        this.factory.getLogger(logName).debug(msg);
    }

    @Override
    protected void doDebug(String msg, Throwable t, String logName) {
        this.factory.getLogger(logName).debug(msg, t);
    }

    @Override
    protected boolean doIsInfoEnabled(String logName) {
        return this.factory.getLogger(logName).isInfoEnabled();
    }

    @Override
    protected void doInfo(String msg, String logName) {
        this.factory.getLogger(logName).info(msg);
    }

    @Override
    protected void doInfo(String msg, Throwable t, String logName) {
        this.factory.getLogger(logName).info(msg, t);
    }

    @Override
    protected void doWarn(String msg) {
        Finding warn = Finding.warning(msg);
        this.factory.getLogger("ROOT").warn(warn.toString());
        this.addFinding(warn);
    }

    @Override
    protected void doWarn(String msg, SourcePosition pos) {
        Finding warn = Finding.warning(msg, pos);
        this.factory.getLogger("ROOT").warn(warn.toString());
        this.addFinding(warn);
    }

    @Override
    protected void doWarn(String msg, Throwable t) {
        Finding warn = Finding.warning(msg);
        this.factory.getLogger("ROOT").warn(warn.toString(), t);
        this.addFinding(warn);
    }

    @Override
    protected void doError(String msg) {
        Finding error = Finding.error(msg);
        this.factory.getLogger("ROOT").error(error.toString());
        this.addFinding(error);
        this.terminateIfErrors();
    }

    @Override
    protected void doError(String msg, SourcePosition pos) {
        Finding error = Finding.error(msg, pos);
        this.factory.getLogger("ROOT").error(error.toString());
        this.addFinding(error);
        this.terminateIfErrors();
    }

    @Override
    protected void doError(String msg, Throwable t) {
        Finding error = Finding.error(msg);
        this.factory.getLogger("ROOT").error(error.toString(), t);
        this.addFinding(error);
        this.terminateIfErrors();
    }
}

