/*
 * Decompiled with CFR 0.152.
 */
package de.se_rwth.commons.logging;

import de.se_rwth.commons.SourcePosition;
import de.se_rwth.commons.logging.Finding;
import de.se_rwth.commons.logging.Slf4jLog;
import java.util.ArrayList;
import java.util.List;

public class Log {
    static Log log;
    boolean failQuick = true;
    List<Finding> findings = new ArrayList<Finding>();

    static Log getLog() {
        if (log == null) {
            Slf4jLog.init();
        }
        return log;
    }

    protected static final void setLog(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("Supplied logging component must not be null!");
        }
        if (Log.log != null) {
            if (!Log.log.getClass().equals(log.getClass())) {
                Log.debug("Switching logging component from " + Log.log.getClass().getName() + " to " + log.getClass().getName(), Log.class.getName());
            }
            ArrayList<Finding> findingsCopy = new ArrayList<Finding>(Log.log.findings);
            log.findings = findingsCopy;
            log.failQuick = Log.log.failQuick;
        }
        Log.log = log;
    }

    protected Log() {
    }

    public static final boolean isTraceEnabled(String logName) {
        return Log.getLog().doIsTraceEnabled(logName);
    }

    protected boolean doIsTraceEnabled(String logName) {
        return true;
    }

    public static final void trace(String msg, String logName) {
        Log.getLog().doTrace(msg, logName);
    }

    protected void doTrace(String msg, String logName) {
        System.out.println("[TRACE] " + logName + " " + msg);
    }

    public static final void trace(String msg, Throwable t, String logName) {
        Log.getLog().doTrace(msg, t, logName);
    }

    protected void doTrace(String msg, Throwable t, String logName) {
        Log.trace(msg, logName);
        t.printStackTrace(System.out);
    }

    public static final boolean isDebugEnabled(String logName) {
        return Log.getLog().doIsDebugEnabled(logName);
    }

    protected boolean doIsDebugEnabled(String logName) {
        return true;
    }

    public static final void debug(String msg, String logName) {
        Log.getLog().doDebug(msg, logName);
    }

    protected void doDebug(String msg, String logName) {
        System.out.println("[DEBUG] " + logName + " " + msg);
    }

    public static final void debug(String msg, Throwable t, String logName) {
        Log.getLog().doDebug(msg, t, logName);
    }

    protected void doDebug(String msg, Throwable t, String logName) {
        Log.debug(msg, logName);
        t.printStackTrace(System.out);
    }

    public static final boolean isInfoEnabled(String logName) {
        return Log.getLog().doIsInfoEnabled(logName);
    }

    protected boolean doIsInfoEnabled(String logName) {
        return true;
    }

    public static final void info(String msg, String logName) {
        Log.getLog().doInfo(msg, logName);
    }

    protected void doInfo(String msg, String logName) {
        System.out.println("[INFO]  " + logName + " " + msg);
    }

    public static final void info(String msg, Throwable t, String logName) {
        Log.getLog().doInfo(msg, t, logName);
    }

    protected void doInfo(String msg, Throwable t, String logName) {
        Log.info(msg, logName);
        t.printStackTrace(System.out);
    }

    public static final void warn(String msg) {
        Log.getLog().doWarn(msg);
    }

    protected void doWarn(String msg) {
        Finding warn = Finding.warning(msg);
        this.addFinding(warn);
        System.out.println("[WARN]  " + warn.toString());
    }

    public static final void warn(String msg, SourcePosition pos) {
        Log.getLog().doWarn(msg, pos);
    }

    protected void doWarn(String msg, SourcePosition pos) {
        Finding warn = Finding.warning(msg, pos);
        this.addFinding(warn);
        System.out.println("[WARN]  " + warn.toString());
    }

    public static final void warn(String msg, Throwable t) {
        Log.getLog().doWarn(msg, t);
    }

    protected void doWarn(String msg, Throwable t) {
        Finding warn = Finding.warning(msg);
        this.addFinding(warn);
        System.out.println("[WARN]  " + warn.toString());
        t.printStackTrace(System.out);
    }

    public static final void error(String msg) {
        Log.getLog().doError(msg);
    }

    protected void doError(String msg) {
        Finding error = Finding.error(msg);
        this.addFinding(error);
        System.err.println("[ERROR] " + error.toString());
        this.terminateIfErrors();
    }

    public static final void error(String msg, SourcePosition pos) {
        Log.getLog().doError(msg, pos);
    }

    protected void doError(String msg, SourcePosition pos) {
        Finding error = Finding.error(msg, pos);
        this.addFinding(error);
        System.err.println("[ERROR] " + error.toString());
        this.terminateIfErrors();
    }

    public static final void error(String msg, Throwable t) {
        Log.getLog().doError(msg, t);
    }

    protected void doError(String msg, Throwable t) {
        Finding error = Finding.error(msg);
        this.addFinding(error);
        System.err.println("[ERROR] " + error.toString());
        t.printStackTrace(System.err);
        this.terminateIfErrors();
    }

    public static final <T> T errorIfNull(T reference, String message) {
        if (reference == null) {
            throw new NullPointerException(message);
        }
        return reference;
    }

    public static final <T> T errorIfNull(T reference) {
        return Log.errorIfNull(reference, "Internal error: a null reference occured (see/enable debug output).");
    }

    public static final void enableFailQuick(boolean enable) {
        Log.getLog().doEnableFailQuick(enable);
    }

    protected void doEnableFailQuick(boolean enable) {
        this.failQuick = enable;
        this.terminateIfErrors();
    }

    public static final long getErrorCount() {
        return Log.getLog().doGetErrorCount();
    }

    protected long doGetErrorCount() {
        return this.findings.stream().filter(f -> f.isError()).count();
    }

    public static final boolean isFailQuickEnabled() {
        return Log.getLog().doIsFailQuickEnabled();
    }

    protected boolean doIsFailQuickEnabled() {
        return this.failQuick;
    }

    protected final void addFinding(Finding finding) {
        this.findings.add(finding);
    }

    protected final void terminateIfErrors() {
        if (Log.isFailQuickEnabled() && Log.getErrorCount() > 0L) {
            System.exit(0);
        }
    }

    public static List<Finding> getFindings() {
        return Log.getLog().doGetFindings();
    }

    protected List<Finding> doGetFindings() {
        return this.findings;
    }
}

