/*
 * Decompiled with CFR 0.152.
 */
package de.se_rwth.commons.logging;

import de.se_rwth.commons.SourcePosition;
import java.util.Optional;

public class Finding {
    private static final String FORMAT_WITH_SOURCEPOSITION = "%s: %s";
    private Type type;
    private String msg;
    private Optional<SourcePosition> sourcePosition;

    public Finding(Type type, String msg, SourcePosition sourcePosition) {
        this.type = type;
        this.msg = msg;
        this.sourcePosition = Optional.ofNullable(sourcePosition);
    }

    public Finding(Type type, String msg) {
        this.type = type;
        this.msg = msg;
        this.sourcePosition = Optional.empty();
    }

    public String buildMsg() {
        if (this.sourcePosition.isPresent()) {
            return String.format(FORMAT_WITH_SOURCEPOSITION, this.sourcePosition.get(), this.msg);
        }
        return this.msg;
    }

    public Optional<SourcePosition> getSourcePosition() {
        return this.sourcePosition;
    }

    public void setSourcePosition(SourcePosition sourcePosition) {
        this.sourcePosition = Optional.ofNullable(sourcePosition);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isWarning() {
        return this.type == Type.WARNING;
    }

    public boolean isError() {
        return this.type == Type.ERROR;
    }

    public String toString() {
        return this.buildMsg();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.msg.hashCode();
        result = 31 * result + this.sourcePosition.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Finding) {
            Finding other = (Finding)obj;
            if (this.msg.equals(other.msg) && this.sourcePosition.equals(other.sourcePosition) && this.type == other.type) {
                return true;
            }
        }
        return false;
    }

    public static Finding error(String message) {
        return new Finding(Type.ERROR, message);
    }

    public static Finding error(String message, SourcePosition sourcePosition) {
        return new Finding(Type.ERROR, message, sourcePosition);
    }

    public static Finding warning(String message) {
        return new Finding(Type.WARNING, message);
    }

    public static Finding warning(String message, SourcePosition sourcePosition) {
        return new Finding(Type.WARNING, message, sourcePosition);
    }

    public static enum Type {
        WARNING,
        ERROR;

    }
}

