package de.monochromata.cucumber.stepdefs.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

import javax.tools.SimpleJavaFileObject;

public class InMemoryCompilerOutput extends SimpleJavaFileObject {

    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    
    public InMemoryCompilerOutput(final String typeName) {
        super(uri(typeName), Kind.CLASS);
    }

    protected static URI uri(final String typeName) {
        final var path = typeName.replace('.', '/');
        return URI.create("string:///" + path + Kind.CLASS.extension);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return outputStream;
    }
    
    public byte[] getClassData() {
        return outputStream.toByteArray();
    }
}