package de.monochromata.cucumber.stepdefs.compiler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.JavaFileObject.Kind;

public class InMemoryOutputFileManager extends ForwardingJavaFileManager<JavaFileManager> {
    
    public Map<String, InMemoryCompilerOutput> outputs = new HashMap<>();

    public InMemoryOutputFileManager(final JavaFileManager delegate) {
        super(delegate);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(
            final Location location, 
            final String className, 
            final Kind kind, 
            final FileObject sibling)
            throws IOException {
        final var output = new InMemoryCompilerOutput(className);
        outputs.put(className, output);
        return output;
    }
    
}
