package de.monochromata.cucumber.stepdefs;

import static nl.jqno.equalsverifier.Warning.STRICT_INHERITANCE;

import io.cucumber.java.en.Given;
import nl.jqno.equalsverifier.EqualsVerifier;

public class EqualsVerifierStepdefs {
    
    @Given("{word} has correct hashcode and equals methods")
    public void correct(final String className) throws ClassNotFoundException {
        EqualsVerifier.forClass(Class.forName(className)).usingGetClass().suppress(STRICT_INHERITANCE).verify();
    }
    
    /**
     * See http://jqno.nl/equalsverifier/errormessages/symmetry-does-not-equal-superclass-instance/
     */
    @Given("{word} adds state to the super-class and has correct hashcode and equals methods")
    public void correctAndAddsState(final String className) throws ClassNotFoundException {
        EqualsVerifier.forClass(Class.forName(className)).usingGetClass().withRedefinedSuperclass()
            .suppress(STRICT_INHERITANCE).verify();
    }
}
