/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.stepdefs;

import de.monochromata.cucumber.stepdefs.ExceptionState;
import de.monochromata.cucumber.stepdefs.JavaCompilerState;
import de.monochromata.cucumber.stepdefs.compiler.InMemoryCompilerOutput;
import de.monochromata.cucumber.stepdefs.compiler.InMemoryCompilerSource;
import de.monochromata.cucumber.stepdefs.compiler.InMemoryOutputFileManager;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class JavaCompilerStepdefs {
    private final JavaCompilerState<Object> state;
    private final ExceptionState exceptionState;

    public JavaCompilerStepdefs(JavaCompilerState state, ExceptionState exceptionState) {
        this.state = state;
        this.exceptionState = exceptionState;
    }

    @Given(value="a class {string} from source:")
    public void aClassFromSource(String className, DocString javaSource) {
        try {
            this.state.clazz = this.compileClass(className, javaSource.getContent(), true);
            this.state.classes = new HashMap();
            this.state.classes.put(className, this.state.clazz);
        }
        catch (Exception e) {
            if (this.state.catchExceptionsForAssertions) {
                this.exceptionState.exception = e;
            }
            throw new RuntimeException("Failed to compile/load class " + className + ", see standard error", e);
        }
    }

    @Given(value="classes {string} from source:")
    public void classesFromSource(String commaSeparatedClassNames, DocString sources) {
        try {
            String[] classNames = commaSeparatedClassNames.split(",");
            String[] documents = sources.getContent().split("---");
            this.state.classes = this.compileClasses(classNames, documents, true);
        }
        catch (Exception e) {
            if (this.state.catchExceptionsForAssertions) {
                this.exceptionState.exception = e;
            }
            throw new RuntimeException("Failed to compile/load classes " + commaSeparatedClassNames + ", see standard error", e);
        }
    }

    @Given(value="a class {string} from source defined by a class loader that does not delegate to its parent:")
    public void aClassFromSourceOSGI(String className, DocString javaSource) {
        try {
            this.state.clazz = this.compileClass(className, javaSource.getContent(), false);
        }
        catch (Exception e) {
            if (this.state.catchExceptionsForAssertions) {
                this.exceptionState.exception = e;
            }
            throw new RuntimeException("Failed to compile/load class " + className + ", see standard error", e);
        }
    }

    @When(value="an instance of the class is created")
    public void anInstanceOfTheClassIsCreated() {
        try {
            this.state.instance = this.state.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            if (this.state.catchExceptionsForAssertions) {
                this.exceptionState.exception = e;
            }
            throw new RuntimeException("Failed to instantiate class via no-args constructor", e);
        }
    }

    @When(value="an instance of {string} is created")
    public void anInstanceIsCreated(String typeName) {
        try {
            Class<?> clazz = this.state.classes.get(typeName);
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.state.instances.put(typeName, instance);
        }
        catch (Exception e) {
            if (this.state.catchExceptionsForAssertions) {
                this.exceptionState.exception = e;
            }
            throw new RuntimeException("Failed to instantiate class via no-args constructor", e);
        }
    }

    protected Class compileClass(String className, String javaSource, boolean delegateToParentClassLoader) throws IOException {
        Map<String, Class<?>> classes = this.compileClasses(new String[]{className}, new String[]{javaSource}, delegateToParentClassLoader);
        return classes.values().iterator().next();
    }

    protected Map<String, Class<?>> compileClasses(String[] classNames, String[] sources, boolean delegateToParentClassLoader) throws IOException {
        List<InMemoryCompilerSource> javaFileObjects;
        InMemoryOutputFileManager fileManager;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Boolean successful = compiler.getTask(null, fileManager = new InMemoryOutputFileManager(compiler.getStandardFileManager(null, null, null)), null, null, null, javaFileObjects = this.javaFileObjects(classNames, sources)).call();
        if (!successful.booleanValue()) {
            throw new RuntimeException("Compilation failed");
        }
        return this.defineClasses(fileManager.outputs, delegateToParentClassLoader);
    }

    protected List<InMemoryCompilerSource> javaFileObjects(String[] classNames, String[] sources) {
        if (classNames.length != sources.length) {
            throw new IllegalArgumentException("Mismatch: you defined " + classNames.length + " class name(s) but the source file is divided into " + sources.length + " source fragment(s) - they should match");
        }
        ArrayList<InMemoryCompilerSource> javaFileObjects = new ArrayList<InMemoryCompilerSource>(classNames.length);
        for (int i = 0; i < classNames.length; ++i) {
            javaFileObjects.add(new InMemoryCompilerSource(classNames[i], sources[i]));
        }
        return javaFileObjects;
    }

    protected Map<String, Class<?>> defineClasses(Map<String, InMemoryCompilerOutput> outputs, boolean delegateToParentClassLoader) {
        if (delegateToParentClassLoader) {
            return DefiningClassLoader.instanceDelegatingToParent(outputs).loadAllClasses();
        }
        return DefiningClassLoader.instanceNotDelegatingToParent(outputs).loadAllClasses();
    }

    protected static class DefiningClassLoader
    extends ClassLoader {
        private final Map<String, InMemoryCompilerOutput> outputs;
        private final Map<String, Class<?>> definedClasses = new HashMap();

        protected DefiningClassLoader(ClassLoader parent, Map<String, InMemoryCompilerOutput> outputs) {
            super(null, parent);
            this.outputs = outputs;
        }

        public Map<String, Class<?>> loadAllClasses() {
            return this.outputs.entrySet().stream().map(entry -> this.loadClassEntry((Map.Entry<String, InMemoryCompilerOutput>)entry)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        protected Map.Entry<String, Class<?>> loadClassEntry(Map.Entry<String, InMemoryCompilerOutput> entry) {
            try {
                return new AbstractMap.SimpleEntry(entry.getKey(), this.loadClass(entry.getKey()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not load internally-defined class", e);
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> definedClass = this.definedClasses.get(name);
            if (definedClass != null) {
                return definedClass;
            }
            InMemoryCompilerOutput output = this.outputs.get(name);
            if (output != null) {
                return this.defineClass(name, output.getClassData());
            }
            return super.loadClass(name, resolve);
        }

        protected Class<?> defineClass(String className, byte[] classData) {
            Class<?> clazz = this.defineClass(className, classData, 0, classData.length);
            this.definedClasses.put(className, clazz);
            return clazz;
        }

        public static DefiningClassLoader instanceDelegatingToParent(Map<String, InMemoryCompilerOutput> outputs) {
            return new DefiningClassLoader(ClassLoader.getSystemClassLoader(), outputs);
        }

        public static DefiningClassLoader instanceNotDelegatingToParent(Map<String, InMemoryCompilerOutput> outputs) {
            return new DefiningClassLoader(null, outputs);
        }
    }
}

