/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.stepdefs;

import de.monochromata.cucumber.stepdefs.ExceptionState;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Then;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class ExceptionStepdefs {
    private final ExceptionState exceptionState;

    public ExceptionStepdefs(ExceptionState exceptionState) {
        this.exceptionState = exceptionState;
    }

    @Then.Thens(value={@Then(value="there is no exception"), @Then(value="no exception is raised/thrown")})
    public void assertNoExceptionIsRaised() {
        Assertions.assertThat((String)this.getStackTrace()).isEmpty();
    }

    @Then(value="a(n) {word} is raised/thrown")
    public void assertException(String simpleTypeName) {
        Assertions.assertThat((Throwable)this.exceptionState.exception).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)this.exceptionState.exception.getClass().getSimpleName()).as("unexpected exception type in " + this.getStackTrace(), new Object[0])).isEqualTo(simpleTypeName);
    }

    @Then(value="the exception is a runtime exception")
    public void assertIsRuntimeException() {
        Assertions.assertThat((Throwable)this.exceptionState.exception).isInstanceOf(RuntimeException.class);
    }

    @Then(value="a(n) {word} is raised/thrown with message:")
    public void assertExceptionWithMessageDocString(String simpleTypeName, DocString message) {
        this.assertExceptionWithMessage(simpleTypeName, message.getContent());
    }

    @Then.Thens(value={@Then(value="a(n) {word} is raised/thrown with message {string}"), @Then(value="a(n) {word} with message {string} is raised/thrown")})
    public void assertExceptionWithMessage(String simpleTypeName, String message) {
        this.assertException(simpleTypeName);
        Assertions.assertThat((String)this.exceptionState.exception.getMessage()).isEqualTo(message);
    }

    @Then.Thens(value={@Then(value="a(n) {word} is raised/thrown with message matching {string}"), @Then(value="a(n) {word} with message matching {string} is raised/thrown")})
    public void assertExceptionWithMessageRegex(String simpleTypeName, String messageRegex) {
        this.assertException(simpleTypeName);
        Assertions.assertThat((String)this.exceptionState.exception.getMessage()).matches((CharSequence)messageRegex);
    }

    @Then(value="the {word} has been caused by a(n) {word}")
    public void assertExceptionCause(String simpleTypeName, String simpleCauseTypeName) {
        this.assertException(simpleTypeName);
        Throwable cause = this.exceptionState.exception.getCause();
        Assertions.assertThat((Throwable)cause).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)cause.getClass().getSimpleName()).as("unexpected exception cause type in " + this.getStackTrace(cause), new Object[0])).isEqualTo(simpleCauseTypeName);
    }

    @Then(value="a(n) {word} is raised/thrown that has been caused by a(n) {word} with message {string}")
    public void assertExceptionCauseWithMessage(String simpleTypeName, String simpleCauseTypeName, String causeMessage) {
        this.assertExceptionCause(simpleTypeName, simpleCauseTypeName);
        Throwable cause = this.exceptionState.exception.getCause();
        ((AbstractStringAssert)Assertions.assertThat((String)cause.getMessage()).as("unexpected exception cause message in " + this.getStackTrace(cause), new Object[0])).isEqualTo(causeMessage);
    }

    @Then(value="a(n) {word} is raised/thrown that has been caused by a(n) {word} with message matching {string}")
    public void assertExceptionCauseWithMessageRegex(String simpleTypeName, String simpleCauseTypeName, String causeMessageRegex) {
        this.assertExceptionCause(simpleTypeName, simpleCauseTypeName);
        Throwable cause = this.exceptionState.exception.getCause();
        ((AbstractStringAssert)Assertions.assertThat((String)cause.getMessage()).as("unexpected exception cause message in " + this.getStackTrace(cause), new Object[0])).matches((CharSequence)causeMessageRegex);
    }

    protected String getStackTrace() {
        Throwable exception = this.exceptionState.exception;
        return this.getStackTrace(exception);
    }

    protected String getStackTrace(Throwable exception) {
        StringWriter writer = new StringWriter();
        if (exception != null) {
            exception.printStackTrace(new PrintWriter(writer));
        }
        return writer.toString();
    }
}

