package de.monochromata.cucumber.stepdefs.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

import javax.tools.SimpleJavaFileObject;

public class InMemoryCompilerSource extends SimpleJavaFileObject {

    private final String source;

    public InMemoryCompilerSource(final String typeName, final String source) {
        super(uri(typeName), Kind.SOURCE);
        this.source = source;
    }

    protected static URI uri(final String typeName) {
        final var path = typeName.replace('.', '/');
        return URI.create("string:///" + path + Kind.SOURCE.extension);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        System.err.println("open output stream ...");
        return super.openOutputStream();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return source;
    }
}