/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.stepdefs;

import de.monochromata.cucumber.stepdefs.JavaCompilerState;
import io.cucumber.docstring.DocString;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;

public class JavaCompilerStepdefs {
    private final JavaCompilerState state;

    public JavaCompilerStepdefs(JavaCompilerState state) {
        this.state = state;
    }

    @Given(value="a class {string} from source:")
    public void aClassFromSource(String className, DocString javaSource) {
        try {
            Path outputDir = this.compileClass(className, javaSource);
            this.state.clazz = this.defineClass(className, outputDir, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compile/load class " + className + ", see standard error", e);
        }
    }

    @Given(value="a class {string} from source defined by a class loader that does not delegate to its parent:")
    public void aClassFromSourceOSGI(String className, DocString javaSource) {
        try {
            Path outputDir = this.compileClass(className, javaSource);
            this.state.clazz = this.defineClass(className, outputDir, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compile/load class " + className + ", see standard error", e);
        }
    }

    @When(value="an instance of the class is created")
    public void anInstanceOfTheClassIsCreated() {
        try {
            this.state.instance = this.state.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate class via no-args constructor", e);
        }
    }

    protected Path compileClass(String className, DocString javaSource) throws IOException {
        Path outputDir;
        Path sourceFile = this.saveSource(className, javaSource.getContent());
        if (!BatchCompiler.compile((String)("-11 " + sourceFile + " -d " + (outputDir = Files.createTempDirectory("outputDir", new FileAttribute[0]))), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null)) {
            throw new RuntimeException("Compilation failed");
        }
        return outputDir;
    }

    protected Path saveSource(String className, String javaSource) throws IOException {
        Path inputDir = Files.createTempDirectory("inputDir", new FileAttribute[0]);
        String filename = this.convertPackageToDirectories(className, ".java");
        Path file = inputDir.resolve(filename);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        return Files.writeString(file, (CharSequence)javaSource, new OpenOption[0]);
    }

    protected Class defineClass(String className, Path outputDir, boolean delegateToParentClassLoader) throws IOException {
        String filename = this.convertPackageToDirectories(className, ".class");
        Path classFile = outputDir.resolve(filename);
        byte[] classData = Files.readAllBytes(classFile);
        return this.defineClass(className, classData, delegateToParentClassLoader);
    }

    protected Class defineClass(String className, byte[] classData, boolean delegateToParentClassLoader) {
        if (delegateToParentClassLoader) {
            return new DefiningClassLoader((String)className, (byte[])classData).definedClass;
        }
        return new ClassLoaderNotDelegatingToParent((String)className, (byte[])classData).definedClass;
    }

    protected String convertPackageToDirectories(String className, String fileSuffix) {
        return className.replace('.', File.separatorChar) + fileSuffix;
    }

    protected static class DefiningClassLoader
    extends ClassLoader {
        protected final Class<?> definedClass;

        protected DefiningClassLoader(String className, byte[] classData) {
            this.definedClass = this.defineClass(className, classData, 0, classData.length);
        }
    }

    protected static class ClassLoaderNotDelegatingToParent
    extends ClassLoader {
        protected final Class<?> definedClass;

        protected ClassLoaderNotDelegatingToParent(String className, byte[] classData) {
            super(null, null);
            this.definedClass = this.defineClass(className, classData, 0, classData.length);
        }
    }
}

