/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.stepdefs;

import de.monochromata.cucumber.stepdefs.JavaCompilerState;
import io.cucumber.java8.En;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;

public class JavaCompilerStepdefs
implements En {
    private final JavaCompilerState state;

    public JavaCompilerStepdefs(JavaCompilerState state) {
        this.state = state;
        this.initialize();
    }

    private void initialize() {
        this.Given("a class {string} from source:", (className, javaSource) -> {
            try {
                Path sourceFile = this.saveSource((String)className, (String)javaSource);
                Path outputDir = Files.createTempDirectory("outputDir", new FileAttribute[0]);
                if (!BatchCompiler.compile((String)("-11 " + sourceFile + " -d " + outputDir), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null)) {
                    throw new RuntimeException("Compilation failed");
                }
                this.state.clazz = this.defineClass((String)className, outputDir);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to compile/load class " + className + ", see standard error", e);
            }
        });
        this.When("an instance of the class is created", () -> {
            try {
                this.state.instance = this.state.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate class via no-args constructor", e);
            }
        });
    }

    protected Path saveSource(String className, String javaSource) throws IOException {
        Path inputDir = Files.createTempDirectory("inputDir", new FileAttribute[0]);
        String filename = this.convertPackageToDirectories(className, ".java");
        Path file = inputDir.resolve(filename);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        return Files.writeString(file, (CharSequence)javaSource, new OpenOption[0]);
    }

    protected Class defineClass(String className, Path outputDir) throws IOException {
        String filename = this.convertPackageToDirectories(className, ".class");
        Path classFile = outputDir.resolve(filename);
        byte[] classData = Files.readAllBytes(classFile);
        return new DefiningClassLoader((String)className, (byte[])classData).definedClass;
    }

    protected String convertPackageToDirectories(String className, String fileSuffix) {
        return className.replace('.', File.separatorChar) + fileSuffix;
    }

    protected static class DefiningClassLoader
    extends ClassLoader {
        protected final Class<?> definedClass;

        protected DefiningClassLoader(String className, byte[] classData) {
            this.definedClass = this.defineClass(className, classData, 0, classData.length);
        }
    }
}

