package de.monochromata.cucumber.stepdefs;

import java.io.File;

import cucumber.api.java8.En;
import net.openhft.compiler.CachedCompiler;
import net.openhft.compiler.CompilerUtils;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class JavaCompilerStepdefs implements En {

    private static final CachedCompiler CACHED_COMPILER = CompilerUtils.DEBUGGING
            ? new CachedCompiler(new File("src/test/java"), null)
            : CompilerUtils.CACHED_COMPILER;

    private final JavaCompilerState state;

    public JavaCompilerStepdefs(final JavaCompilerState state) {
        this.state = state;
        initialize();
    }

    private void initialize() {
        Given("^a class (\\w+) from source:$", (final String className, final String javaSource) -> {
            try {
                state.clazz = CACHED_COMPILER.loadFromJava(className, javaSource);
            } catch (final Exception e) {
                throw new RuntimeException("Failed to compile/load class, see standard error" + className, e);
            }
        });

        When("^an instance of the class is created$", () -> {
            try {
                state.instance = state.clazz.newInstance();
            } catch (final Exception e) {
                throw new RuntimeException("Failed to instantiate class via no-args constructor", e);
            }
        });
    }

}
